package cn.com.duiba.activity.center.api.remoteservice.singleAward;

import cn.com.duiba.activity.center.api.domain.dto.singleAward.SingleAwardConfigDto;
import java.util.List;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteSingleAwardConfigService {

    /**
     * 编辑/保存活动
     * @param singleAwardConfigDto
     * @return
     * @throws BizException
     */
    Boolean edit(SingleAwardConfigDto singleAwardConfigDto) throws BizException;

    /**
     * 详情
     * @param actId
     * @return
     * @throws BizException
     */
    SingleAwardConfigDto getDetail(Long actId);

    /**
     * 删除
     * @param id
     */
    void deleteById(Long id);

    void deleteBatchByIds(List<Long> ids) throws BizException;

    Integer updateById(SingleAwardConfigDto singleAwardConfigDto) throws BizException;


    List<SingleAwardConfigDto> listByIds(List<Long> ids) throws BizException;

}
