package cn.com.duiba.activity.center.api.enums;

import java.util.stream.Stream;

/**
 * Created by hong
 * time 2022/9/28.
 */

public enum ShopGuideTypeEnum {

    MONTHLY_EVENTS_CALENDAR(1, "monthlyEventsCalendar", "月度活动日历"),
    CAROUSEL_EVENT_POSTER(2, "carouselEventPoster", "轮播活动海报"),
    POPULAR_ACTIVITIES(3, "popularActivities", "热门活动"),
    ADDITIONAL_MODULES(4, "additionalModules", "增购模块"),
    ACTIVITY_MODULE(5, "activityModule", "活动模块"),
    DECORATION_MODULE(6, "decorationModule", "装修模块"),
    MARKETING_MODULE(7, "marketingModule", "营销模块"),
    PRODUCT_RECOMMEND_PRODUCT(8,"productRecommend","优质好货商品推荐"),
    PRODUCT_RECOMMEND_COUPON(9,"productRecommend","大牌好卷商品推荐"),
    PRODUCT_RECOMMEND_RECHARGE(10,"productRecommend","直冲商品推荐"),
    PRODUCT_RECOMMEND_TITLE(11,"productRecommendTitle","推荐商品标题"),
    RECOMMEND_POSTER_PRODUCT(12,"recommendPoster","优质好货推荐海报"),
    RECOMMEND_POSTER_COUPON(13,"recommendPoster","大牌好卷推荐海报"),
    RECOMMEND_POSTER_RECHARGE(14,"recommendPoster","直冲推荐海报"),
    PRODUCT_SALE_LEADERBOARD(15,"productSaleLeaderboard","商品销量排行榜")
    ;

    private final Integer code;

    private final String  type;

    private final String  desc;

    ShopGuideTypeEnum(Integer code, String type, String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public static ShopGuideTypeEnum getByCode(Integer code) {
        return Stream.of(ShopGuideTypeEnum.values()).filter(e -> e.getCode().equals(code)).findFirst().orElse(MONTHLY_EVENTS_CALENDAR);
    }

    public static ShopGuideTypeEnum getByType(String type) {
        return Stream.of(ShopGuideTypeEnum.values()).filter(e -> e.getType().equals(type)).findFirst().orElse(MONTHLY_EVENTS_CALENDAR);
    }

    public Integer getCode() {
        return code;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}