package cn.com.duiba.activity.center.api.enums.richman;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 大富翁经过终点 事件
 * @author 歪大哥😁
 * @date 2020-08-14.
 */
public enum RichManPassEndingEventEnum {

    RETURN(1, "退回再来"),

    ;

    private int code;

    private String desc;


    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    RichManPassEndingEventEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer, RichManPassEndingEventEnum> map;

    static {
        Map<Integer, RichManPassEndingEventEnum> temp = Maps.newHashMap();

        for (RichManPassEndingEventEnum value : values()) {
            temp.put(value.code, value);
        }
        map = temp;
    }

    public static RichManPassEndingEventEnum getByCode(Integer code) {
        return map.get(code);
    }

}
