package cn.com.duiba.activity.center.api.remoteservice.manual;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * 
 * ClassName: RemoteAppManualLotteryServiceNew <br/>
 * date: 2016年12月1日 下午3:41:33 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAppManualLotteryServiceNew {

    /**
     * 
     * scanOverManualLottery:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    List<AppManualLotteryDto> scanOverManualLottery();

    /**
     * 
     * updateManualLottery:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appManualLottery
     * @since JDK 1.6
     */
    void updateManualLottery(AppManualLotteryDto appManualLottery);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appManualLotteryDto
     * @return
     * @since JDK 1.6
     */
    AppManualLotteryDto insert(AppManualLotteryDto appManualLotteryDto);

    /**
     * 
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param appManualLotteryDto
     * @since JDK 1.6
     */
    void update(AppManualLotteryDto appManualLotteryDto);

    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    AppManualLotteryDto find(Long id);
    
    /**
     * 
     * findAllByIds:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param ids
     * @return
     * @since JDK 1.6
     */
    List<AppManualLotteryDto> findAllByIds(List<Long> ids);


    //from AppManualLotteryService in developer

    /**
     * @auth huangwq
     * @description 解析参数并新增一条抽奖数据
     */
    public DubboResult<AppManualLotteryDto> insertAppManualLottery(AppManualLotteryDto lottery) ;

    /**
     * @auth zhangpan
     * @description 解析参数并新增一条抽奖数据
     * @param params
     */
    @RequestMapping("/insertAppManualLottery1")
    public DubboResult<AppManualLotteryDto> insertAppManualLottery(Map<String,Object> params);

    public DubboResult<Void> updateAppManualLottery(AppManualLotteryDto lottery) ;

    /**
     * @auth zhangpan
     * @description 更新
     * @param params
     * @return
     */
    @RequestMapping("/updateAppManualLottery1")
    public DubboResult<Void> updateAppManualLottery(Map<String,Object> params) ;

    /**
     * @auth huangwq
     * @description 把开发者添加的人工开奖加入到活动列表中
     * @param appManualLotteryDO
     */
    public DubboResult<Void> appManualLotteryToActivity(AppManualLotteryDto appManualLotteryDO) ;

}
