package cn.com.duiba.activity.center.biz.dao.activity.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityOptionsDao;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityOptionsEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/12.
 */
@Repository
public class OperatingActivityOptionsDaoImpl extends ActivityBaseDao implements OperatingActivityOptionsDao {

    //from HdtoolSimpleDAO

    public OperatingActivityOptionsEntity findOptionById(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findOptionById", paramMap);
    }

    public List<OperatingActivityOptionsEntity> findByOperatingActivityId(Long operatingActivityId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectList("findByOperatingActivityId", paramMap);
    }

    public Integer countByOperatingActivityId(Long operatingActivityId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("countByOperatingActivityId", paramMap);
    }

    //from HdtoolTextChangeDAO


    public int decrementOptionRemaining(Long optionId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", optionId);
        return update("decrementOptionRemaining", paramMap);
    }

    public int incrementOptionRemaining(Long optionId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", optionId);
        return update("incrementOptionRemaining", paramMap);
    }

    public int updateOptionDeleteStatus(List<Long> oaoList) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("oaoList", oaoList);
        return update("updateOptionDeleteStatus", paramMap);
    }

    public int updatePrize(OperatingActivityOptionsEntity OperatingActivityOptionsEntity) {
        return update("updatePrize", OperatingActivityOptionsEntity);
    }

    public void insertOption(OperatingActivityOptionsEntity OperatingActivityOptionsEntity) {
        update("insertOption", OperatingActivityOptionsEntity);
    }

    public int updateOption(OperatingActivityOptionsEntity OperatingActivityOptionsEntity) {
        return update("updateOption", OperatingActivityOptionsEntity);
    }

    public OperatingActivityOptionsEntity findForupdate(Long id){
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findForupdate", paramMap);
    }

    //from OperatingActivityOptionsStatusChangeDAO

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("addRemaining", addRemaining);
        return update("addRemainingById", paramMap);
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("subRemaining", subRemaining);
        return update("subRemainingById", paramMap);
    }

    @Override
    public int updateRemainingById(Long id, Integer remaining) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("remaining", remaining);
        return update("updateRemainingById", paramMap);
    }

    @Override
    public Integer findRemaingForupdate(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findRemaingForupdate", paramMap);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}
