/**
 * Project Name:activity-center-biz
 * File Name:ActivityCategoryRelationDaoImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.category.impl
 * Date:2016年6月8日下午5:14:50
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.category.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.category.ActivityCategoryRelationDao;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;

/**
 * ClassName:ActivityCategoryRelationDaoImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年6月8日 下午5:14:50 <br/>
 * @author   duiba
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Repository
public class ActivityCategoryRelationDaoImpl extends ActivityBaseDao implements ActivityCategoryRelationDao{
    
    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }

    @Override
    public List<ActivityCategoryRelationEntity> selectByAppCategory(long appId, long categoryId) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("appId", appId);
        params.put("categoryId", categoryId);
        return selectList("selectByAppCategory",params);
    }


    @Override
    public int updatePayload(long id, int payload) {
        Map<String, Object> params=new HashMap<String, Object>();
        params.put("id", id);
        params.put("payload", payload);
        return update("updatePayload",params);
    }

}

