package cn.com.duiba.activity.center.biz.dao.hdtool.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.hdtool.HdtoolStockConsumeDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolStockConsumeEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

@Repository
public class HdtoolStockConsumeDaoImpl extends ActivityBaseDao implements HdtoolStockConsumeDao{

	@Override
	public int insert(HdtoolStockConsumeEntity hdtoolStockConsumeDto) {
		return insert("insert", hdtoolStockConsumeDto);
	}

	@Override
	public HdtoolStockConsumeEntity findByBizIdAndSourcePay(String bizId,
														 String bizSource) {
		Map<String,Object> map = new HashMap<String,Object>();
		map.put("bizId", bizId);
		map.put("bizSource", bizSource);
		return selectOne("findByBizIdAndSourcePay", map);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS;
	}
}
