package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameStockManualChangeDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameStockManualChangeEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class DuibaNgameStockManualChangeDaoImpl extends ActivityBaseDao implements DuibaNgameStockManualChangeDao {

	@Override
	public List<DuibaNgameStockManualChangeEntity> findByStockId(Long gameStockId) {
		return selectList("findByStockId", gameStockId);
	}

	@Override
	public void addBatch(List<DuibaNgameStockManualChangeEntity> list) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("list", list);
		insert("addBatch", params);
	}

	@Override
	public void add(DuibaNgameStockManualChangeEntity gameStockManualChangeDO) {
		insert("add", gameStockManualChangeDO);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
