package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.NgameOrdersExtraDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameOrdersExtraEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.Map;

@Repository
public class NgameOrdersExtraDaoImpl extends ActivityBaseDao implements NgameOrdersExtraDao {

	@Override
	public NgameOrdersExtraEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	public NgameOrdersExtraEntity findByGameOrderId(Long gameOrderId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("gameOrderId", gameOrderId);
		return selectOne("findByGameOrderId", paramMap);
	}

	@Override
	public void insert(NgameOrdersExtraEntity gameOrdersExtraDO) {
		insert("insert", gameOrdersExtraDO);
	}

	@Override
	public int updateOrderId(Long id, Long mainOrderId, String mainOrderNum) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("mainOrderId", mainOrderId);
		paramMap.put("mainOrderNum", mainOrderNum);
		return update("updateOrderId", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
