package cn.com.duiba.activity.center.biz.entity.seconds_kill;

import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.LinkedListMultimap;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DuibaSecondsKillActivityEntity implements Serializable {

	private static final long serialVersionUID = 2663209699152220311L;

	public static final Integer SWITCHES_DIRECT = 0; // 定向发放

	public static final Integer SWITCHES_DEV_BLACKLIST = 1; // 黑名单商品
	public static final Integer STATUS_UNPUBLISH = 0; // 未发布
	public static final Integer STATUS_STARTUP = 1; // 开启
	public static final Integer STATUS_SHUTDOWN = 2; // 关闭

	private Long id;

	private String title;

	private Integer status;

	private Long switches;

	private String logo;

	private String smallImage;

	private String whiteImage;

	private String indexBannerImage;

	private String topicBannerImage;

	private String recommendImage;

	private Long duibaSecondsKillActivityBrickId;

	private String areasImagesItems;

	private String nextTitle;

	private String nextImage;

	private String rule;

	private Date autoOffDate;
	
	private Date autoOnDate;

	private Boolean deleted;

	private Date gmtCreate;

	private Date gmtModified;

	public void openSwitch(int s) {
		int v = 1 << s;
		switches = switches | v;
	}

	public void closeSwitch(int s) {
		int v = 1 << s;
		v = ~v;
		switches = switches & v;
	}

	public boolean isOpenSwitch(int s) {
		int v = 1 << s;
		long ret = switches & v;
		return ret != 0;
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Long getSwitches() {
		return switches;
	}

	public void setSwitches(Long switches) {
		this.switches = switches;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public String getIndexBannerImage() {
		return indexBannerImage;
	}

	public void setIndexBannerImage(String indexBannerImage) {
		this.indexBannerImage = indexBannerImage;
	}

	public String getTopicBannerImage() {
		return topicBannerImage;
	}

	public void setTopicBannerImage(String topicBannerImage) {
		this.topicBannerImage = topicBannerImage;
	}

	public String getRecommendImage() {
		return recommendImage;
	}

	public void setRecommendImage(String recommendImage) {
		this.recommendImage = recommendImage;
	}

	public Long getDuibaSecondsKillActivityBrickId() {
		return duibaSecondsKillActivityBrickId;
	}

	public void setDuibaSecondsKillActivityBrickId(Long duibaSecondsKillActivityBrickId) {
		this.duibaSecondsKillActivityBrickId = duibaSecondsKillActivityBrickId;
	}

	public String getAreasImagesItems() {
		return areasImagesItems;
	}

	public void setAreasImagesItems(String areasImagesItems) {
		this.areasImagesItems = areasImagesItems;
	}

	public String getNextTitle() {
		return nextTitle;
	}

	public void setNextTitle(String nextTitle) {
		this.nextTitle = nextTitle;
	}

	public String getNextImage() {
		return nextImage;
	}

	public void setNextImage(String nextImage) {
		this.nextImage = nextImage;
	}

	public String getRule() {
		return rule;
	}

	public void setRule(String rule) {
		this.rule = rule;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}
	
	public Date getAutoOnDate() {
		return autoOnDate;
	}

	public void setAutoOnDate(Date autoOnDate) {
		this.autoOnDate = autoOnDate;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public DuibaSecondsKillActivityEntity(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public DuibaSecondsKillActivityEntity() {
	}

	public class ItemsArea implements Comparable<ItemsArea>,Serializable {

		private static final long serialVersionUID = 5747386046804719282L;
		private int index;

		private String title;

		private Date killtime;
		
		private String killhour;
		/**
		 * true:已抢光
		 * false:未抢光
		 */
		private boolean isLoot;
		private List<Long> itemIds;

		public ItemsArea() {
		}

		public ItemsArea(int index, String title, Date killtime, List<Long> itemIds,String killhour) {
			this.index = index;
			this.title = title;
			this.killtime = killtime;
			this.killhour = killhour;
			this.itemIds = itemIds;
		}
		
		public int getIndex() {
			return index;
		}

		public void setIndex(int index) {
			this.index = index;
		}

		public String getTitle() {
			return title;
		}

		public void setTitle(String title) {
			this.title = title;
		}

		public Date getKilltime() {
			return killtime;
		}

		public void setKilltime(Date killtime) {
			this.killtime = killtime;
		}
		
		public boolean isLoot() {
			return isLoot;
		}

		public void setLoot(boolean isLoot) {
			this.isLoot = isLoot;
		}

		public String getKillhour() {
			return killhour;
		}

		public void setKillhour(String killhour) {
			this.killhour = killhour;
		}

		public List<Long> getItemIds() {
			return itemIds;
		}

		public void setItemIds(List<Long> itemIds) {
			this.itemIds = itemIds;
		}

		@Override
		public int compareTo(ItemsArea o) {
			if(this.killhour!=null && StringUtils.isNotBlank(this.killhour)){
				if(this.isLoot != o.isLoot){
					//根据是否已抢光排序
					if(!this.isLoot && o.isLoot ) 
						return -1;
					else
						return 1;
				}else{
					//根据抽奖时间点排序
					if( Integer.parseInt(this.killhour) < Integer.parseInt(o.getKillhour()))
						return -1;
					else if ( Integer.parseInt(this.killhour) > Integer.parseInt(o.getKillhour()))
						return 1;
					else return 0;
				}
			}else {
				if (this.index < o.index) {
					return -1;
				}
				if (this.index > o.index) {
					return 1;
				}
				return 0;
			}
		}

	}

	/**
	 * 获取区域解析后的内容
	 */
	public List<ItemsArea> getItemsAreaList() {
		if (StringUtils.isBlank(areasImagesItems)) {
			return null;
		}
		List<ItemsArea> list = new ArrayList<ItemsArea>();
		JSONObject o = JSON.parseObject(areasImagesItems);
		for (String it : o.keySet()) {
			JSONObject temp = JSON.parseObject(o.get(it).toString());

			List<Long> itemIds = new ArrayList<Long>();
			for (int j = 0; j < temp.getJSONArray("items").size(); j++) {
				JSONObject t = (JSONObject) temp.getJSONArray("items").get(j);
				itemIds.add(t.getLong("itemId"));
			}

			int index = Integer.valueOf(it);
			String title = temp.getString("title");
			Date killtime = DateUtils.getMinuteDate(temp.getString("killtime"));
			String strKillhour = temp.getString("killhour");
			list.add(new ItemsArea(index, title, killtime, itemIds,strKillhour));
		}
		Collections.sort(list);
		return list;
	}

	/**
	 * 判断兑换项是否在活动中
	 */
	public boolean isItemIdInActivity(Long itemId) {
		if (StringUtils.isBlank(areasImagesItems)) {
			throw new RuntimeException("无兑换项");
		}
		JSONObject o = JSON.parseObject(areasImagesItems);
		for (String it : o.keySet()) {
			JSONObject temp = JSON.parseObject(o.get(it).toString());
			for (int j = 0; j < temp.getJSONArray("items").size(); j++) {
				JSONObject t = (JSONObject) temp.getJSONArray("items").get(j);
				if (itemId.equals(t.getLong("itemId"))) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * 获取itemIds 1697,2,3,1,4,5,3,1697,1667 形式，无序
	 */
	public String getItemIds() {
		if (StringUtils.isBlank(areasImagesItems)) {
			return null;
		}
		JSONObject o = JSON.parseObject(areasImagesItems);
		StringBuffer buffer = new StringBuffer();
		for (String it : o.keySet()) {
			JSONObject temp = JSON.parseObject(o.get(it).toString());
			int size = temp.getJSONArray("items").size();
			for (int j = 0; j < size; j++) {
				JSONObject t = (JSONObject) temp.getJSONArray("items").get(j);
				buffer.append(t.getLong("itemId"));
				buffer.append(",");
			}
		}
		String result = buffer.toString();
		return result.substring(0, result.length() != 0 ? (result.length() - 1) : 0);
	}
	
	/**
	 * 获取itemIdList [1697, 2, 3, 1, 4, 5, 3, 1697, 1667] 无序
	 */
	public List<Long> getItemIdList() {
		if (StringUtils.isBlank(areasImagesItems)) {
			return null;
		}
		JSONObject o = JSON.parseObject(areasImagesItems);
		List<Long> idList = new ArrayList<Long>();
		for (String it : o.keySet()) {
			JSONObject temp = JSON.parseObject(o.get(it).toString());
			int size = temp.getJSONArray("items").size();
			for (int j = 0; j < size; j++) {
				JSONObject t = (JSONObject) temp.getJSONArray("items").get(j);
				idList.add(t.getLong("itemId"));
			}
		}
		return idList;
	}

	public void setNextActivityJson(String nextActivityJson){
		if (StringUtils.isBlank(nextActivityJson)) {
			return;
		}
		JSONObject nextActivity = JSON.parseObject(nextActivityJson);
		this.nextTitle = nextActivity.getString("nextTitle");
		this.nextImage = nextActivity.getString("nextImg");
		this.rule = nextActivity.getString("nextRules");
		this.autoOffDate = nextActivity.getDate("nextAutoOffDate");
	}

	/**
	 * {1=[1697, 1667], 2=[1697, 2, 3, 1, 4, 5, 3]}
	 */
	public LinkedListMultimap<String, Long> getItemIdMap() {
		LinkedListMultimap<String, Long> multiMap = LinkedListMultimap.create();
		if (StringUtils.isBlank(areasImagesItems)) {
			return multiMap;
		}
		JSONObject o = JSON.parseObject(areasImagesItems);
		for (int i = 1; i <= o.size(); i++) {
			JSONObject temp = JSON.parseObject(o.get(i + "").toString());
			int size = temp.getJSONArray("items").size();
			for (int j = 0; j < size; j++) {
				JSONObject t = (JSONObject) temp.getJSONArray("items").get(j);
				multiMap.put(i + "", t.getLong("itemId"));
			}
		}
		return multiMap;
	}

	public static Long getOperatingActivityId(Long itemId, String ids) {
		JSONObject json = JSON.parseObject(ids);
		for (String key : json.keySet()) {
			JSONArray array = json.getJSONObject(key).getJSONArray("items");
			for (int i = 0; i < array.size(); i++) {
				Long ii = array.getLong(i);
				if (itemId.equals(ii)) {
					return Long.valueOf(key);
				}
			}
		}
		return null;
	}
}
