package cn.com.duiba.activity.center.biz.remoteservice.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;
import cn.com.duiba.activity.center.api.remoteservice.RemoteManualLotteryService;
import cn.com.duiba.activity.center.biz.service.manual.AppManualLotteryService;
import cn.com.duiba.activity.center.biz.service.manual.ManualOrderLotteryService;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by xuezhaoming on 16/6/6.
 */
@Service
public class RemoteManualLotteryServiceImpl implements RemoteManualLotteryService {

    private static final Logger       LOGGER = LoggerFactory.getLogger(RemoteManualLotteryServiceImpl.class);

    @Resource
    private AppManualLotteryService   appManualLotteryService;

    @Resource
    private ManualOrderLotteryService manualOrderLotteryService;

    @Override
    public DubboResult<List<AppManualLotteryDto>> scanOverManualLottery() {

        try {
            List<AppManualLotteryDto> appManualLotteryDtos = appManualLotteryService.scanOverManualLottery();
            return DubboResult.successResult(appManualLotteryDtos);
        } catch (Exception e) {
            LOGGER.error("scanOverManualLottery error ", e);
            return DubboResult.failResult(e.getMessage());
        }

    }

    @Override
    public void updateManualLottery(AppManualLotteryDto appManualLottery) {

        if (appManualLottery == null) {
            return;
        }

        try {
            appManualLotteryService.updateManualLottery(appManualLottery);
        } catch (Exception e) {
            LOGGER.error("data :" + appManualLottery.toString(), e.getMessage());

        }
    }

    @Override
    public void insert(AppManualLotteryDto appManualLotteryDto) {

        if (appManualLotteryDto == null) {
            return;
        }

        try {
            appManualLotteryService.insert(appManualLotteryDto);
        } catch (Exception e) {
            LOGGER.error("data :" + appManualLotteryDto.toString(), e.getMessage());
        }
    }

    @Override
    public void update(AppManualLotteryDto appManualLotteryDto) {
        if (appManualLotteryDto == null) {
            return;
        }

        try {
            appManualLotteryService.update(appManualLotteryDto);
        } catch (Exception e) {
            LOGGER.error("data :" + appManualLotteryDto.toString(), e.getMessage());
        }
    }

    @Override
    public DubboResult<AppManualLotteryDto> find(Long id) {
        if (id == null) {
            return DubboResult.failResult("param is null ");
        }

        try {
            AppManualLotteryDto appManualLotteryDto = appManualLotteryService.find(id);
            return DubboResult.successResult(appManualLotteryDto);

        } catch (Exception e) {

            LOGGER.error("find:" + id, e.getMessage());
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        if (consumerId == null || operatingActivityId == null) {
            return DubboResult.failResult("param is null");
        }

        try {
            Integer integer = manualOrderLotteryService.countByConsumerIdAndOperatingActivityId(consumerId,
                                                                                                operatingActivityId);
            return DubboResult.successResult(integer);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId,
                                                                               Long operatingActivityId, Date start,
                                                                               Date end) {
        if (consumerId == null || operatingActivityId == null) {
            return DubboResult.failResult("param is null ");
        }

        try {
            Integer integer = manualOrderLotteryService.countByConsumerIdAndOperatingActivityIdAndDate(consumerId,
                                                                                                       operatingActivityId,
                                                                                                       start, end);
            return DubboResult.successResult(integer);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        if (consumerId == null || operatingActivityId == null) {
            return DubboResult.failResult("param is null ");
        }

        try {
            Integer integer = manualOrderLotteryService.countFreeByConsumerIdAndOperatingActivityId(consumerId,
                                                                                                    operatingActivityId);
            return DubboResult.successResult(integer);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId,
                                                                                   Long operatingActivityId,
                                                                                   Date start, Date end) {
        if (consumerId == null || operatingActivityId == null) {
            return DubboResult.failResult("param is null ");
        }

        try {
            Integer integer = manualOrderLotteryService.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId,
                                                                                                           operatingActivityId,
                                                                                                           start, end);
            return DubboResult.successResult(integer);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ManualLotteryOrderDto>> findAllOpenManualLotteryByCondition(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult("param is null");
        }
        try {
            List<ManualLotteryOrderDto> orderDTOs = manualOrderLotteryService.findAllOpenManualLotteryByCondition(paramMap);

            return DubboResult.successResult(orderDTOs);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> findAllOpenManualLotteryCount(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult("param is null");
        }

        try {
            Long lotteryCount = manualOrderLotteryService.findAllOpenManualLotteryCount(paramMap);

            return DubboResult.successResult(lotteryCount);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ManualLotteryOrderDto>> findWardList(Long operatingActivityId) {
        if (operatingActivityId == null) {
            return DubboResult.failResult("param is null ");
        }

        try {
            List<ManualLotteryOrderDto> wardList = manualOrderLotteryService.findWardList(operatingActivityId);

            return DubboResult.successResult(wardList);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ManualLotteryOrderDto>> findNoWardList(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult("param is null");
        }

        try {
            List<ManualLotteryOrderDto> wardList = manualOrderLotteryService.findNoWardList(paramMap);

            return DubboResult.successResult(wardList);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Long> findNoWardListCount(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult("param is null");
        }

        try {
            Long noWardListCount = manualOrderLotteryService.findNoWardListCount(paramMap);

            return DubboResult.successResult(noWardListCount);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ManualLotteryOrderDto>> findStartOpenListByIds(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult("param is null");
        }

        try {
            List<ManualLotteryOrderDto> dtoList = manualOrderLotteryService.findStartOpenListByIds(paramMap);

            return DubboResult.successResult(dtoList);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<Integer> updateAward(Long id, Long activityId, Date date) {
        if (id == null || activityId == null) {
            return DubboResult.failResult("param is null");
        }

        try {
            int count = manualOrderLotteryService.updateAward(id, activityId, date);

            return DubboResult.successResult(count);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<ManualLotteryOrderDto> randomFindManualLottery(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult("param is null ");
        }

        try {
            ManualLotteryOrderDto manualLotteryOrderDto = manualOrderLotteryService.randomFindManualLottery(paramMap);

            return DubboResult.successResult(manualLotteryOrderDto);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public void updateNoAwardList(Map<String, Object> paramMap) {

        if (paramMap == null || paramMap.size() == 0) {
            return;
        }

        try {
            manualOrderLotteryService.updateNoAwardList(paramMap);

        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }

    }

    @Override
    public DubboResult<List<ManualLotteryOrderDto>> findAllNoAwardList(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return DubboResult.failResult("param is null");
        }

        try {
            List<ManualLotteryOrderDto> allNoAwardList = manualOrderLotteryService.findAllNoAwardList(paramMap);

            return DubboResult.successResult(allNoAwardList);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<List<ManualLotteryOrderDto>> findAllByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return DubboResult.failResult("param is null");
        }

        try {
            List<ManualLotteryOrderDto> allNoAwardList = manualOrderLotteryService.findAllByIds(ids);

            return DubboResult.successResult(allNoAwardList);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<ManualLotteryOrderDto> findByOrderId(Long orderId) {
        if (orderId == null) {
            return DubboResult.failResult("param is null");
        }

        try {
            ManualLotteryOrderDto orderDTO = manualOrderLotteryService.findByOrderId(orderId);

            return DubboResult.successResult(orderDTO);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public DubboResult<ManualLotteryOrderDto> findByAppAndDeveloperBizId(Long appId, String bizId) {
        if (appId == null || StringUtils.isBlank(bizId)) {
            return DubboResult.failResult("param is null ");
        }

        try {
            ManualLotteryOrderDto orderDTO = manualOrderLotteryService.findByAppAndDeveloperBizId(appId, bizId);

            return DubboResult.successResult(orderDTO);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }

    @Override
    public void insert(ManualLotteryOrderDto manualLotteryOrderDto) {
        if (manualLotteryOrderDto == null) {
            return;
        }

        try {
            manualOrderLotteryService.insert(manualLotteryOrderDto);

        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }

    }

    @Override
    public void update(ManualLotteryOrderDto manualLotteryOrderDto) {
        if (manualLotteryOrderDto == null) {
            return;
        }

        try {
            manualOrderLotteryService.update(manualLotteryOrderDto);

        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    public DubboResult<ManualLotteryOrderDto> findOrder(Long id) {
        if (id == null) {
            return DubboResult.failResult("param is null ");
        }

        try {
            ManualLotteryOrderDto orderDTO = manualOrderLotteryService.find(id);

            return DubboResult.successResult(orderDTO);
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            return DubboResult.failResult(e.getMessage());
        }
    }
}
