package cn.com.duiba.activity.center.biz.remoteservice.impl.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.NgameStockDto;
import cn.com.duiba.activity.center.api.remoteservice.ngame.RemoteNgameStockService;
import cn.com.duiba.activity.center.biz.service.ngame.NgameStockService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/15.
 */
@Service
public class RemoteNgameStockServiceImpl implements RemoteNgameStockService {
    @Resource
    private NgameStockService ngameStockService;

    @Override
    public NgameStockDto findRemaining(Long relationId) {
        return ngameStockService.findRemaining(relationId);
    }

    @Override
    public int subStock(Long id, Integer subNumber) {
        return ngameStockService.subStock(id, subNumber);
    }

    @Override
    public int addStock(Long id, Integer addNumber) {
        return ngameStockService.addStock(id, addNumber);
    }

    @Override
    public NgameStockDto findByGameOptionId(Long gameOptionId) {
        return ngameStockService.findByGameOptionId(gameOptionId);
    }

    @Override
    public List<NgameStockDto> findByGameOptionIds(List<Long> list) {
        return ngameStockService.findByGameOptionIds(list);
    }

    @Override
    public void updateStock(NgameStockDto ngameStockDto) {
        ngameStockService.updateStock(ngameStockDto);
    }

    @Override
    public NgameStockDto add(NgameStockDto ngameStockDto) {
        ngameStockService.add(ngameStockDto);
        return ngameStockDto;
    }

    @Override
    public void addBatch(List<NgameStockDto> list) {
        ngameStockService.addBatch(list);
    }
}
