/**
 * Project Name:activity-center-biz
 * File Name:ActivityCategoryRelationServiceImpl.java
 * Package Name:cn.com.duiba.activity.center.biz.service.impl
 * Date:2016年6月8日下午5:07:24
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.service.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.biz.dao.category.ActivityCategoryRelationDao;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;

/**
 * ClassName:ActivityCategoryRelationServiceImpl <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2016年6月8日 下午5:07:24 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public class ActivityCategoryRelationServiceImpl implements ActivityCategoryRelationService{
    private static final Logger log=LoggerFactory.getLogger(ActivityCategoryRelationServiceImpl.class);
    @Autowired
    private ActivityCategoryRelationDao activityCategoryRelationDao;
    @Override
    public List<ActivityCategoryRelationEntity> findByAppCategory(long appId, long categoryId) {
        return this.activityCategoryRelationDao.selectByAppCategory(appId, categoryId);
    }
    @Override
    @Transactional
    public boolean sortActivities(List<CategoryActivityDto> activities) {
        boolean rs = true;
        try{
            for(CategoryActivityDto dto:activities){
                if(1==this.activityCategoryRelationDao.updatePayload(dto.getId(), dto.getPayload())){
                    continue;
                }else{
                    rs = false;
                }
            }
        }catch(Exception e){
            rs = false;
            log.error("更新权重值出错",e);
        }
        
        return rs;
    }

}

