package cn.com.duiba.activity.center.biz.service.manual.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.annotation.Resource;

import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.biz.dao.manuallottery.AppManualLotteryDao;
import cn.com.duiba.activity.center.biz.entity.manual.AppManualLotteryEntity;
import cn.com.duiba.activity.center.biz.service.manual.AppManualLotteryService;
import cn.com.duiba.activity.center.biz.support.CacheConstants;
import cn.com.duiba.activity.center.biz.support.copier.manual.AppManualLotteryCopier;
import cn.com.duiba.wolf.cache.CacheClient;

import com.google.common.base.Preconditions;

/**
 * Created by wenqi.huang on 16/5/13.
 */
@Service
public class AppManualLotteryServiceImpl implements AppManualLotteryService {

    @Resource
    private AppManualLotteryDao appManualLotteryDao;

    @Resource
    private CacheClient         cacheClient;

    private String getCacheKeyById(Long id) {
        return CacheConstants.KEY_APP_MANUAL_LOTTERY_BY_ID + id;
    }

    @Override
    public List<AppManualLotteryDto> scanOverManualLottery() {
        List<AppManualLotteryEntity> entities = appManualLotteryDao.scanOverManualLottery();
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }

        List<AppManualLotteryDto> appManualLotteryDtos = new ArrayList<>(entities.size());
        for (AppManualLotteryEntity appManualLotteryEntity : entities) {
            AppManualLotteryDto appManualLotteryDto = new AppManualLotteryDto();
            AppManualLotteryCopier.Entity2DTO.copy(appManualLotteryEntity, appManualLotteryDto, null);

            appManualLotteryDtos.add(appManualLotteryDto);
        }

        return appManualLotteryDtos;
    }

    @Override
    public void updateManualLottery(AppManualLotteryDto appManualLottery) {
        Preconditions.checkNotNull(appManualLottery);

        AppManualLotteryEntity appManualLotteryEntity = dto2entity(appManualLottery);

        appManualLotteryDao.updateManualLottery(appManualLotteryEntity);
        cacheClient.remove(getCacheKeyById(appManualLottery.getId()));
    }

    private AppManualLotteryEntity dto2entity(AppManualLotteryDto appManualLottery) {
        AppManualLotteryEntity appManualLotteryEntity = AppManualLotteryCopier.dto2Entity(appManualLottery);
        return appManualLotteryEntity;
    }

    @Override
    public void insert(AppManualLotteryDto appManualLotteryDto) {

        Preconditions.checkNotNull(appManualLotteryDto);

        AppManualLotteryEntity appManualLotteryEntity = dto2entity(appManualLotteryDto);
        appManualLotteryDao.insert(appManualLotteryEntity);
    }

    @Override
    public void update(AppManualLotteryDto appManualLotteryDto) {
        Preconditions.checkNotNull(appManualLotteryDto);

        AppManualLotteryEntity appManualLotteryEntity = dto2entity(appManualLotteryDto);

        appManualLotteryDao.update(appManualLotteryEntity);
        cacheClient.remove(getCacheKeyById(appManualLotteryDto.getId()));
    }

    @Override
    public AppManualLotteryDto find(Long id) {
        String key = getCacheKeyById(id);
        AppManualLotteryDto d = cacheClient.get(key);
        if (d == null) {
            AppManualLotteryEntity appManualLotteryEntity = appManualLotteryDao.find(id);
            if (appManualLotteryEntity == null) {
                return null;
            }

            d = AppManualLotteryCopier.entity2dto(appManualLotteryEntity);
            cacheClient.set(key, d, 1, TimeUnit.HOURS);
        }
        return d;
    }
}
