package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.NgameConsumerRecordDto;
import cn.com.duiba.activity.center.biz.dao.ngame.NgameConsumerRecordDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameConsumerRecordEntity;
import cn.com.duiba.activity.center.biz.service.ngame.NgameConsumerRecordService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/16.
 */
@Service
public class NgameConsumerRecordServiceImpl implements NgameConsumerRecordService {
    @Resource
    private NgameConsumerRecordDao ngameConsumerRecordDao;

    @Override
    public NgameConsumerRecordDto findRecordByConIdAndNgameId(Long consumerId, Long duibaNgameId) {
        return BeanUtils.copy(ngameConsumerRecordDao.findRecordByConIdAndNgameId(consumerId, duibaNgameId), NgameConsumerRecordDto.class);
    }

    @Override
    public List<NgameConsumerRecordDto> findGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number) {
        return BeanUtils.copyList(ngameConsumerRecordDao.findGameConfigDuibaScoreByDesc(duibaNgameId, number), NgameConsumerRecordDto.class);
    }

    @Override
    public List<NgameConsumerRecordDto> findGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number) {
        return BeanUtils.copyList(ngameConsumerRecordDao.findGameConfigDuibaScoreByAsc(duibaNgameId, number), NgameConsumerRecordDto.class);
    }

    @Override
    public List<NgameConsumerRecordDto> findConsumerGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number) {
        return BeanUtils.copyList(ngameConsumerRecordDao.findConsumerGameConfigDuibaScoreByDesc(duibaNgameId, number), NgameConsumerRecordDto.class);
    }

    @Override
    public List<NgameConsumerRecordDto> findConsumerGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number) {
        return BeanUtils.copyList(ngameConsumerRecordDao.findConsumerGameConfigDuibaScoreByAsc(duibaNgameId, number), NgameConsumerRecordDto.class);
    }

    @Override
    public void insert(NgameConsumerRecordDto gameConsumerRecordDO) {
        NgameConsumerRecordEntity e = BeanUtils.copy(gameConsumerRecordDO, NgameConsumerRecordEntity.class);
        ngameConsumerRecordDao.insert(e);
        gameConsumerRecordDO.setId(e.getId());
    }

    @Override
    public Integer updateScore(Long id, Long score, String autoOpenPrizeId, Long gameOrderId) {
        return ngameConsumerRecordDao.updateScore(id, score, autoOpenPrizeId, gameOrderId);
    }

    @Override
    public Integer updateScoreAndTotalScore(Long id, Long score, Integer shareScore, String autoOpenPrizeId, Long gameOrderId) {
        return ngameConsumerRecordDao.updateScoreAndTotalScore(id, score, shareScore, autoOpenPrizeId, gameOrderId);
    }

    @Override
    public Integer updateTotalScore(Long id, Integer shareScore) {
        return ngameConsumerRecordDao.updateTotalScore(id, shareScore);
    }

    @Override
    public Integer updateIsGivePrize(Long id, Boolean isGivePrize) {
        return ngameConsumerRecordDao.updateIsGivePrize(id, isGivePrize);
    }

    @Override
    public Integer updateAutoOpenPrizeId(Long id, String autoOpenPrizeId) {
        return ngameConsumerRecordDao.updateAutoOpenPrizeId(id, autoOpenPrizeId);
    }

    @Override
    public void markCheat(Long id, Boolean cheat) {
        ngameConsumerRecordDao.markCheat(id, cheat);
    }

    @Override
    public List<NgameConsumerRecordDto> findByConsumerAndIds(Long consumerId, List<Long> ids) {
        return BeanUtils.copyList(ngameConsumerRecordDao.findByConsumerAndIds(consumerId, ids), NgameConsumerRecordDto.class);
    }

    @Override
    public List<NgameConsumerRecordDto> findTopWinning(Map<String, Object> params) {
        return BeanUtils.copyList(ngameConsumerRecordDao.findTopWinning(params), NgameConsumerRecordDto.class);
    }

    @Override
    public List<NgameConsumerRecordDto> findTopWinningAsc(Map<String, Object> params) {
        return BeanUtils.copyList(ngameConsumerRecordDao.findTopWinningAsc(params), NgameConsumerRecordDto.class);
    }

    @Override
    public Integer countCheatBefore(Integer limit, Long gameConfigDuibaId) {
        return ngameConsumerRecordDao.countCheatBefore(limit, gameConfigDuibaId);
    }

    @Override
    public Integer countTopWinning(Map<String, Object> params) {
        return ngameConsumerRecordDao.countTopWinning(params);
    }

    @Override
    public NgameConsumerRecordDto find(Long id) {
        return BeanUtils.copy(ngameConsumerRecordDao.find(id), NgameConsumerRecordDto.class);
    }

    @Override
    public void setCheatReason(Long id, String cheatReason) {
        ngameConsumerRecordDao.setCheatReason(id, cheatReason);
    }

    @Override
    public List<NgameConsumerRecordDto> findShareConsumerByGameConfigDuibaId(Long duibaNgameId) {
        return BeanUtils.copyList(ngameConsumerRecordDao.findShareConsumerByGameConfigDuibaId(duibaNgameId), NgameConsumerRecordDto.class);
    }

    @Override
    public int updateByGameConfigShare(Long id, Long duibaNgameId, Long shareScore) {
        return ngameConsumerRecordDao.updateByGameConfigShare(id, duibaNgameId, shareScore);
    }

    @Override
    public NgameConsumerRecordDto findByConsumerIdAndGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId) {
        return BeanUtils.copy(ngameConsumerRecordDao.findByConsumerIdAndGameConfigDuibaId(consumerId, gameConfigDuibaId), NgameConsumerRecordDto.class);
    }
}
