package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.NgameStockDto;
import cn.com.duiba.activity.center.biz.dao.ngame.NgameStockDao;
import cn.com.duiba.activity.center.biz.entity.ngame.NgameStockEntity;
import cn.com.duiba.activity.center.biz.service.ngame.NgameStockService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/15.
 */
@Service
public class NgameStockServiceImpl implements NgameStockService {
    @Resource
    private NgameStockDao ngameStockDao;

    public void add(NgameStockDto ngameStockDto) {
        NgameStockEntity e = BeanUtils.copy(ngameStockDto, NgameStockEntity.class);
        ngameStockDao.add(e);
        ngameStockDto.setId(e.getId());
    }

    public void addBatch(List<NgameStockDto> list) {
        ngameStockDao.addBatch(BeanUtils.copyList(list, NgameStockEntity.class));
    }

    public void updateStock(NgameStockDto ngameStockDto) {
        ngameStockDao.updateStock(BeanUtils.copy(ngameStockDto, NgameStockEntity.class));
    }

    @Override
    public NgameStockDto findRemaining(Long relationId) {
        return BeanUtils.copy(ngameStockDao.findRemaining(relationId), NgameStockDto.class);
    }

    @Override
    public int subStock(Long id, Integer subNumber) {
        return ngameStockDao.subStock(id, subNumber);
    }

    @Override
    public int addStock(Long id, Integer addNumber) {
        return ngameStockDao.addStock(id, addNumber);
    }

    @Override
    public NgameStockDto findByGameOptionId(Long gameOptionId) {
        return BeanUtils.copy(ngameStockDao.findByGameOptionId(gameOptionId), NgameStockDto.class);
    }

    @Override
    public List<NgameStockDto> findByGameOptionIds(List<Long> list) {
        return BeanUtils.copyList(ngameStockDao.findByGameOptionIds(list), NgameStockDto.class);
    }
}
