package cn.com.duiba.activity.center.biz.service.quizz.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzDao;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzService;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/13.
 */
@Service
public class DuibaQuizzServiceImpl implements DuibaQuizzService {

    @Resource
    private DuibaQuizzDao duibaQuizzDao;

    @Override
    public DuibaQuizzDto find(Long id) {

        DuibaQuizzEntity duibaQuizzEntity = duibaQuizzDao.find(id);
        if (duibaQuizzEntity == null) {
            return null;
        }

        return BeanUtils.copy(duibaQuizzEntity, DuibaQuizzDto.class);
    }

    @Override
    public List<DuibaQuizzDto> findByPage(Integer offset, Integer max) {

        List<DuibaQuizzEntity> byPage = duibaQuizzDao.findByPage(offset, max);
        if (CollectionUtils.isEmpty(byPage)) {
            return Collections.emptyList();
        }

        return BeanUtils.copyList(byPage, DuibaQuizzDto.class);
    }

    @Override
    public Long findPageCount(Map<String, Object> paramMap) {
        return duibaQuizzDao.findPageCount(paramMap);
    }

    @Override
    public List<DuibaQuizzDto> findByPage(Map<String, Object> paramMap) {
        if (paramMap == null || paramMap.size() == 0) {
            return Collections.emptyList();
        }

        List<DuibaQuizzEntity> byPage = duibaQuizzDao.findByPage(paramMap);
        if (CollectionUtils.isEmpty(byPage)) {
            return Collections.emptyList();
        }

        return BeanUtils.copyList(byPage, DuibaQuizzDto.class);
    }

    @Override
    public int updateStatus(Long id, int status) {
        return duibaQuizzDao.updateStatus(id, status);
    }

    @Override
    public int delete(Long id) {
        return duibaQuizzDao.delete(id);
    }

    @Override
    public int insert(DuibaQuizzDto duibaQuizzDto) {
        Preconditions.checkNotNull(duibaQuizzDto);

        DuibaQuizzEntity entity = BeanUtils.copy(duibaQuizzDto, DuibaQuizzEntity.class);
        return duibaQuizzDao.insert(entity);
    }

    @Override
    public int updateInfoForm(DuibaQuizzDto duibaQuizzDto) {
        DuibaQuizzEntity entity = BeanUtils.copy(duibaQuizzDto, DuibaQuizzEntity.class);
        return duibaQuizzDao.updateInfoForm(entity);
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        return duibaQuizzDao.updateAutoOffDateNull(id);
    }

    @Override
    public int updateSwitches(Long id, Long switches) {
        return duibaQuizzDao.updateSwitches(id, switches);
    }

    @Override
    public List<DuibaQuizzDto> findAutoOff() {
        List<DuibaQuizzEntity> autoOff = duibaQuizzDao.findAutoOff();
        if (CollectionUtils.isEmpty(autoOff)) {
            return Collections.emptyList();
        }
        return BeanUtils.copyList(autoOff, DuibaQuizzDto.class);
    }

    @Override
    public List<DuibaQuizzDto> findAllByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }

        List<DuibaQuizzEntity> allByIds = duibaQuizzDao.findAllByIds(ids);
        if (CollectionUtils.isEmpty(allByIds)) {
            return Collections.emptyList();
        }

        return BeanUtils.copyList(allByIds, DuibaQuizzDto.class);

    }

    @Override
    public List<AddActivityDto> findAllQuizz() {

        List<AddActivityEntity> allQuizz = duibaQuizzDao.findAllQuizz();
        if (CollectionUtils.isEmpty(allQuizz)) {
            return Collections.emptyList();
        }

        return BeanUtils.copyList(allQuizz, AddActivityDto.class);
    }

    @Override
    public int update(DuibaQuizzDto duibaQuizzDto) {

        Preconditions.checkNotNull(duibaQuizzDto);

        DuibaQuizzEntity copy = BeanUtils.copy(duibaQuizzDto, DuibaQuizzEntity.class);
        return duibaQuizzDao.update(copy);

    }
}
