package cn.com.duiba.activity.center.biz.service.quizz.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersDao;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzOrdersService;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/8.
 */
@Service
public class QuizzOrdersServiceImpl implements QuizzOrdersService {

    @Resource
    private QuizzOrdersDao quizzOrdersDao;

    @Override
    public QuizzOrdersDto find(Long id) {
        Preconditions.checkNotNull(id, "id is null");
        return BeanUtils.copy(quizzOrdersDao.find(id), QuizzOrdersDto.class);
    }

    @Override
    public List<Long> findExpireOrder() {
        return quizzOrdersDao.findExpireOrder();
    }

    @Override
    public List<QuizzOrdersDto> findAllByIds(List<Long> ids) {
        Preconditions.checkArgument(CollectionUtils.isNotEmpty(ids));
        return BeanUtils.copyList(quizzOrdersDao.findAllByIds(ids), QuizzOrdersDto.class);
    }
}
