package cn.com.duiba.activity.center.biz.service.seconds_kill.impl;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.seconds_kill.DuibaSecondsKillActivityAppSpecifyDto;
import cn.com.duiba.activity.center.biz.dao.seconds_kill.DuibaSecondsKillActivityAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.seconds_kill.DuibaSecondsKillActivityAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.seconds_kill.DuibaSecondsKillActivityAppSpecifyService;
import cn.com.duiba.wolf.utils.BeanUtils;

/**
 * Created by wenqi.huang on 16/5/24.
 */
@Service
public class DuibaSecondsKillActivityAppSpecifyServiceImpl implements DuibaSecondsKillActivityAppSpecifyService {
    @Resource
    private DuibaSecondsKillActivityAppSpecifyDao duibaSecondsKillActivityAppSpecifyDao;

    @Override
    public DuibaSecondsKillActivityAppSpecifyDto findByDuibaActivityAndApp(Long duibaSecondsKillActivityId, Long appId) {
        return BeanUtils.copy(duibaSecondsKillActivityAppSpecifyDao.findByDuibaActivityAndApp(duibaSecondsKillActivityId, appId), DuibaSecondsKillActivityAppSpecifyDto.class);
    }

    @Override
    public List<DuibaSecondsKillActivityAppSpecifyDto> findByDuibaSecondsKillActivityId(Long duibaSecondsKillActivityId) {
        return BeanUtils.copyList(duibaSecondsKillActivityAppSpecifyDao.findByDuibaSecondsKillActivityId(duibaSecondsKillActivityId), DuibaSecondsKillActivityAppSpecifyDto.class);
    }

    @Override
    public void insert(DuibaSecondsKillActivityAppSpecifyDto duibaSecondsKillActivityAppSpecify) {
        duibaSecondsKillActivityAppSpecifyDao.insert(BeanUtils.copy(duibaSecondsKillActivityAppSpecify, DuibaSecondsKillActivityAppSpecifyEntity.class));
    }

    @Override
    public void delete(Long id) {
        duibaSecondsKillActivityAppSpecifyDao.delete(id);
    }

    @Override
    public DuibaSecondsKillActivityAppSpecifyDto find(Long id) {
        return BeanUtils.copy(duibaSecondsKillActivityAppSpecifyDao.find(id), DuibaSecondsKillActivityAppSpecifyDto.class);
    }

    @Override
    public DuibaSecondsKillActivityAppSpecifyDto findByDuibaSecondsKillActivityAndApp(Long duibaSecondsKillActivityId, Long appId) {
        return BeanUtils.copy(duibaSecondsKillActivityAppSpecifyDao.findByDuibaSecondsKillActivityAndApp(duibaSecondsKillActivityId, appId), DuibaSecondsKillActivityAppSpecifyDto.class);
    }
}
