package cn.com.duiba.activity.center.biz.service.singlelottery.impl;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryAppSpecifyDto;
import cn.com.duiba.activity.center.biz.dao.singlelottery.DuibaSingleLotteryDao;
import cn.com.duiba.activity.center.biz.entity.singlelottery.DuibaSingleLotteryEntity;
import cn.com.duiba.activity.center.biz.entity.singlelottery.SingleLotteryAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/17.
 */
@Service
public class DuibaSingleLotteryServiceImpl implements DuibaSingleLotteryService{
    @Resource
    private DuibaSingleLotteryDao duibaSingleLotteryDao;

    @Override
    public List<DuibaSingleLotteryDto> findAutoOff() {
        return BeanUtils.copyList(duibaSingleLotteryDao.findAutoOff(),DuibaSingleLotteryDto.class);
    }

    @Override
    public DuibaSingleLotteryDto find(Long id) {
        return BeanUtils.copy(duibaSingleLotteryDao.find(id),DuibaSingleLotteryDto.class);
    }

    @Override
    public List<DuibaSingleLotteryDto> findSingleLotteryPage(Map<String, Object> queryMap) {
        return BeanUtils.copyList(duibaSingleLotteryDao.findSingleLotteryPage(queryMap),DuibaSingleLotteryDto.class);
    }

    @Override
    public List<DuibaSingleLotteryDto> findSingleLottery(Map<String, Object> queryMap) {
        return BeanUtils.copyList(duibaSingleLotteryDao.findSingleLottery(queryMap),DuibaSingleLotteryDto.class);
    }

    @Override
    public Long findSingleLotteryPageCount(Map<String, Object> queryMap) {
        return duibaSingleLotteryDao.findSingleLotteryPageCount(queryMap);
    }

    @Override
    public List<AddActivityDto> findAllDuibaSingleLottery(Long appId) {
        return BeanUtils.copyList(duibaSingleLotteryDao.findAllDuibaSingleLottery(appId),AddActivityDto.class);
    }

    @Override
    public List<DuibaSingleLotteryDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(duibaSingleLotteryDao.findAllByIds(ids),DuibaSingleLotteryDto.class);
    }

    @Override
    public Long getCountDuibaSingleLottery(Map<String, Object> queryMap) {
        return duibaSingleLotteryDao.getCountDuibaSingleLottery(queryMap);
    }

    @Override
    public SingleLotteryAppSpecifyDto findSpecifyByDuibaSingleLotteryAndApp(Long duibaSingleLotteryId, Long appId) {
        return BeanUtils.copy(duibaSingleLotteryDao.findSpecifyByDuibaSingleLotteryAndApp(duibaSingleLotteryId, appId),SingleLotteryAppSpecifyDto.class);
    }

    @Override
    public List<SingleLotteryAppSpecifyDto> findAllSpecifyByDuibaSingleLottery(Long duibaSingleLotteryId) {
        return BeanUtils.copyList(duibaSingleLotteryDao.findAllSpecifyByDuibaSingleLottery(duibaSingleLotteryId),SingleLotteryAppSpecifyDto.class);
    }

    @Override
    public SingleLotteryAppSpecifyDto findSpecifyById(Long id) {
        return BeanUtils.copy(duibaSingleLotteryDao.findSpecifyById(id),SingleLotteryAppSpecifyDto.class);
    }

    @Override
    public List<Long> findHasUserdSingleIds(Long itemId) {
        return duibaSingleLotteryDao.findHasUserdSingleIds(itemId);
    }

    @Override
    public SingleLotteryAppSpecifyDto findSpecifyForupdate(Long id) {
        return BeanUtils.copy(duibaSingleLotteryDao.findSpecifyForupdate(id),SingleLotteryAppSpecifyDto.class);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return BeanUtils.copy(duibaSingleLotteryDao.findExtraInfoById(id),ActivityExtraInfoDto.class);
    }

    @Override
    public int updateAutoOffDate(Long id) {
        return duibaSingleLotteryDao.updateAutoOffDate(id);
    }

    @Override
    public void insert(DuibaSingleLotteryDto duibaSingleLotteryDO) {
        DuibaSingleLotteryEntity entity=new DuibaSingleLotteryEntity(true);
        BeanUtils.copy(duibaSingleLotteryDO, entity);
        duibaSingleLotteryDao.insert(entity);
        duibaSingleLotteryDO.setId(entity.getId());
    }

    @Override
    public int update(DuibaSingleLotteryDto duibaSingleLotteryDO) {
        return duibaSingleLotteryDao.update(BeanUtils.copy(duibaSingleLotteryDO,DuibaSingleLotteryEntity.class));
    }

    @Override
    public int reduceMainItemRemaining(Long id) {
        return duibaSingleLotteryDao.reduceMainItemRemaining(id);
    }

    @Override
    public int addMainItemRemaining(Long id) {
        return duibaSingleLotteryDao.addMainItemRemaining(id);
    }

    @Override
    public int reduceInciteItemRemaining(Long id) {
        return duibaSingleLotteryDao.reduceInciteItemRemaining(id);
    }

    @Override
    public int addInciteItemRemaining(Long id) {
        return duibaSingleLotteryDao.addInciteItemRemaining(id);
    }

    @Override
    public int updateForAdminEdit(DuibaSingleLotteryDto duibaSingleLotteryDO) {
        return duibaSingleLotteryDao.updateForAdminEdit(BeanUtils.copy(duibaSingleLotteryDO,DuibaSingleLotteryEntity.class));
    }

    @Override
    public int reduceSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId) {
        return duibaSingleLotteryDao.reduceSpecifyAppRemaining(duibaSingleLotteryId, appId);
    }

    @Override
    public int addSpecifyAppRemaining(Long duibaSingleLotteryId, Long appId) {
        return duibaSingleLotteryDao.addSpecifyAppRemaining(duibaSingleLotteryId, appId);
    }

    @Override
    public int addSpecifyOrderCount(Long duibaSingleLotteryId, Long appId) {
        return duibaSingleLotteryDao.addSpecifyOrderCount(duibaSingleLotteryId, appId);
    }

    @Override
    public int deleteSpecify(Long id) {
        return duibaSingleLotteryDao.deleteSpecify(id);
    }

    @Override
    public void insertAppSpecify(SingleLotteryAppSpecifyDto singleLotteryAppSpecifyDO) {
        duibaSingleLotteryDao.insertAppSpecify(BeanUtils.copy(singleLotteryAppSpecifyDO, SingleLotteryAppSpecifyEntity.class));
    }

    @Override
    public int updateSpecifyRemaining(Long id, Integer remaining) {
        return duibaSingleLotteryDao.updateSpecifyRemaining(id, remaining);
    }

    @Override
    public int addMainItemRemainingById(Long id, Integer addMainItemRemaining) {
        return duibaSingleLotteryDao.addMainItemRemainingById(id, addMainItemRemaining);
    }

    @Override
    public int subMainItemRemainingById(Long id, Integer subMainItemRemaining) {
        return duibaSingleLotteryDao.subMainItemRemainingById(id, subMainItemRemaining);
    }

    @Override
    public int addInciteItemRemainingById(Long id, Integer addInciteItemRemaining) {
        return duibaSingleLotteryDao.addInciteItemRemainingById(id, addInciteItemRemaining);
    }

    @Override
    public int subInciteItemRemainingById(Long id, Integer subInciteItemRemaining) {
        return duibaSingleLotteryDao.subInciteItemRemainingById(id, subInciteItemRemaining);
    }

    @Override
    public DuibaSingleLotteryDto findForupdate(Long id) {
        return BeanUtils.copy(duibaSingleLotteryDao.findForupdate(id),DuibaSingleLotteryDto.class);
    }
}
