package cn.com.duiba.activity.center.biz.bo.game;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionStockDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionStockManualChangeDto;
import cn.com.duiba.activity.center.api.dto.game.QuestionStockConsumeDto;
import cn.com.duiba.activity.center.biz.dao.DsConstants;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionStockConsumeService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionStockManualChangeService;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionStockService;
import cn.com.duiba.service.exception.BusinessException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;

/**
 * Created by wenqi.huang on 16/6/1.
 */
@Service
public class DuibaQuestionStockBo {
    private Logger log = Logger.getLogger(DuibaQuestionStockBo.class);

    @Resource
    private DuibaQuestionStockConsumeService duibaQuestionStockConsumeService;
    @Autowired
    private DuibaQuestionStockService duibaQuestionStockService;
    @Autowired
    private DuibaQuestionStockManualChangeService duibaQuestionStockManualChangeService;

    //from QuestionAnswerStockServiceImpl in credits

    @Transactional(value = DsConstants.DATABASE_CREDITS_GAME)
    public void consumeStock(Long questionOptionId, String questionOrderId) throws BusinessException {
        DuibaQuestionStockDto questionStock = duibaQuestionStockService.findRemaining(questionOptionId, DuibaQuestionStockDto.TYPE_DUIBA);
        if (questionStock.getStock() > 0) {
            int quantity = 1;
            int ret = duibaQuestionStockService.subStock(questionStock.getId(), quantity);
            if (ret < 1) {
                throw new BusinessException("消费奖项库存异常");
            }
            QuestionStockConsumeDto questionStockConsumer = new QuestionStockConsumeDto();
            questionStockConsumer.setBizId(questionOrderId);
            questionStockConsumer.setAction(QuestionStockConsumeDto.ACTION_PAY);
            questionStockConsumer.setQuestionStockId(questionStock.getId());
            questionStockConsumer.setQuantity(quantity);
            questionStockConsumer.setGmtCreate(new Date());
            questionStockConsumer.setGmtModified(new Date());
            duibaQuestionStockConsumeService.insert(questionStockConsumer);
        }
    }

    @Transactional(value = DsConstants.DATABASE_CREDITS_GAME)
    public void paybackStock(String questionOrderId) throws BusinessException {
        QuestionStockConsumeDto payConsume = duibaQuestionStockConsumeService.findByBizId(questionOrderId, QuestionStockConsumeDto.ACTION_PAY);
        if (payConsume != null) {
            int quantity = payConsume.getQuantity();
            int ret = duibaQuestionStockService.addStock(payConsume.getQuestionStockId(), quantity);
            if (ret < 1) {
                throw new BusinessException("返还奖项库存异常");
            }
            QuestionStockConsumeDto questionStockConsumer = new QuestionStockConsumeDto();
            questionStockConsumer.setBizId(questionOrderId);
            questionStockConsumer.setAction(QuestionStockConsumeDto.ACTION_BACK);
            questionStockConsumer.setQuestionStockId(payConsume.getQuestionStockId());
            questionStockConsumer.setQuantity(quantity);
            questionStockConsumer.setGmtCreate(new Date());
            questionStockConsumer.setGmtModified(new Date());
            duibaQuestionStockConsumeService.insert(questionStockConsumer);
        }
    }

    //from DuibaQuestionStockServiceImpl in manager

    @Transactional(value = DsConstants.DATABASE_CREDITS_GAME)
    public void updateStockByOptions(DuibaQuestionAnswerOptionsDto option){
        Integer addOrSub = DuibaQuestionAnswerOptionsDto.ADD;
        int diff = 0;
        DuibaQuestionStockDto stockDO = duibaQuestionStockService.findByQuestionOptionId(option.getId());
        if(stockDO == null){
            stockDO = new DuibaQuestionStockDto();
            stockDO.setQuestionOptionId(option.getId());
            stockDO.setRelationType(DuibaQuestionStockDto.TYPE_DUIBA);
            stockDO.setStock(option.getNewOptionCount());
            duibaQuestionStockService.add(stockDO);
            diff = option.getNewOptionCount();
            addOrSub = DuibaQuestionStockManualChangeDto.ADD;
            if(diff != 0){
                DuibaQuestionStockDto newStock = duibaQuestionStockService.findByQuestionOptionId(option.getId());
                DuibaQuestionStockManualChangeDto stockManualChangeDO = new DuibaQuestionStockManualChangeDto();
                stockManualChangeDO.setQuestionStockId(stockDO.getId());
                stockManualChangeDO.setBeforeStock(0);
                stockManualChangeDO.setAfterStock(newStock.getStock());
                stockManualChangeDO.setChangeKind(addOrSub);
                stockManualChangeDO.setChangeQuantity(Math.abs(diff));
                duibaQuestionStockManualChangeService.add(stockManualChangeDO);
            }
        }
    }

    @Transactional(value = DsConstants.DATABASE_CREDITS_GAME)
    public void updateStockByOptions(DuibaQuestionAnswerOptionsDto option, DuibaQuestionAnswerOptionsDto old) throws BusinessException {
        Integer addOrSub = DuibaQuestionStockManualChangeDto.ADD;
        int diff = 0;
        DuibaQuestionStockDto stockDO = duibaQuestionStockService.findByQuestionOptionId(option.getId());
        if(stockDO == null){
            stockDO = new DuibaQuestionStockDto();
            stockDO.setQuestionOptionId(option.getId());
            stockDO.setRelationType(DuibaQuestionStockDto.TYPE_DUIBA);
            stockDO.setStock(option.getNewOptionCount());
            duibaQuestionStockService.add(stockDO);
            diff = option.getNewOptionCount();
            addOrSub = DuibaQuestionAnswerOptionsDto.ADD;
        }else{
            Integer oldStock = stockDO.getStock();
            Integer nowCount = option.getNewOptionCount();
            diff = (oldStock==null?0:oldStock) - (nowCount==null?0:nowCount);
            if(diff == 0){
                return ;
            }
            stockDO.setStock(diff);
            int result = 0;
            //sub
            if(diff > 0){
                addOrSub = DuibaQuestionStockManualChangeDto.SUB;
                result = duibaQuestionStockService.updateStockSub(stockDO.getId(),stockDO.getStock(),stockDO.getRelationType());
                if(result!=1) {
                    log.error("答题奖项库存减少错误了！");
                    throw new BusinessException("答题奖项库存减少错误了！");
                }
            }else{
                //add
                addOrSub = DuibaQuestionStockManualChangeDto.ADD;
                result = duibaQuestionStockService.updateStockAdd(stockDO.getId(),Math.abs(stockDO.getStock()),stockDO.getRelationType());
                if(result!=1) {
                    log.error("答题奖项库存增加错误了！");
                    throw new BusinessException("答题奖项库存增加错误了！");
                }
            }
            //奖项数量有改变才记录
            if(diff != 0){
                DuibaQuestionStockDto newStock = duibaQuestionStockService.findByQuestionOptionId(option.getId());
                DuibaQuestionStockManualChangeDto stockManualChangeDO = new DuibaQuestionStockManualChangeDto();
                stockManualChangeDO.setQuestionStockId(stockDO.getId());
                stockManualChangeDO.setBeforeStock(oldStock);
                stockManualChangeDO.setAfterStock(newStock.getStock());
                stockManualChangeDO.setChangeKind(addOrSub);
                stockManualChangeDO.setChangeQuantity(Math.abs(diff));
                duibaQuestionStockManualChangeService.add(stockManualChangeDO);
            }
        }
    }

}
