package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerAppSpecifyEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaQuestionAnswerAppSpecifyDaoImpl extends ActivityBaseDao implements DuibaQuestionAnswerAppSpecifyDao {

	@Override
	public DuibaQuestionAnswerAppSpecifyEntity findByQuestionAnswerIdAndAppId(Long questionId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("questionAnswerId", questionId);
		paramMap.put("appId", appId);
		return selectOne("findByQuestionAnswerIdAndAppId",paramMap);
	}

	@Override
	public List<DuibaQuestionAnswerAppSpecifyEntity> findByDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaQuestionAnswerId", duibaQuestionAnswerId);
		return selectList("findByDuibaQuestionAnswerId", paramMap);
	}

	@Override
	public void delete(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		delete("delete", paramMap);
	}

	@Override
	public void insert(DuibaQuestionAnswerAppSpecifyEntity duibaQuestionAnswerAppSpecify) {
		insert("insert", duibaQuestionAnswerAppSpecify);
	}

	@Override
	public DuibaQuestionAnswerAppSpecifyEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}
}
