package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionRecordDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionRecordEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaQuestionRecordDaoImpl extends ActivityBaseDao implements DuibaQuestionRecordDao {


	@Override
	public List<DuibaQuestionRecordEntity> findByBankIdsAndPage(List<String> qBankIds, Integer offset, Integer max) {
		Map<String, Object> parames = new HashMap<String, Object>();
		parames.put("list", qBankIds);
		parames.put("offset", offset);
		parames.put("max", max);
		return selectList("findByBankIdsAndPage", parames);
	}

	@Override
	public Integer totalRecordByBankIds(List<String> qBankIds) {
		Map<String, Object> parames = new HashMap<String, Object>();
		parames.put("list", qBankIds);
		return selectOne("totalRecordByBankIds", parames);
	}

	@Override
	public List<DuibaQuestionRecordEntity> findByBankIdAndLimit(Long qBankId, Integer limit) {
		Map<String, Object> parames = new HashMap<String, Object>();
		parames.put("qBankId", qBankId);
		parames.put("limit", limit);
		return selectList("findByBankIdAndLimit", parames);
	}

	@Override
	public void insert(DuibaQuestionRecordEntity questionRecordDO) {
		insert("insert", questionRecordDO);
	}

	@Override
	public List<DuibaQuestionRecordEntity> findByPage(Long questionBankId, Integer offset, Integer max) {
		Map<String, Object> params=new HashMap<String, Object>();
		params.put("offset", offset);
		params.put("max", max);
		params.put("questionBankId", questionBankId);
		return selectList("findByPage", params);
	}

	@Override
	public Long findTotalCount(Long questionBankId) {
		Map<String, Object> params=new HashMap<String, Object>();
		params.put("questionBankId", questionBankId);
		return selectOne("findTotalCount", params);
	}

	@Override
	public int delete(Long id) {
		return update("delete", id);
	}

	@Override
	public DuibaQuestionRecordEntity findById(Long id) {
		return selectOne("findById", id);
	}

	@Override
	public Long findCountByBankIdsStr(List<String> bankIds) {
		Map<String, Object> params=new HashMap<String, Object>();
		params.put("bankIds", bankIds);
		return selectOne("findCountByBankIdsStr", params);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}
}
