package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrderTextChangeDao;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.support.TableHelper;

@Repository("quizzOrderTextChangeDAO")
public class QuizzOrderTextChangeDaoImpl extends ActivityBaseDao implements QuizzOrderTextChangeDao {

    private static Logger log = LoggerFactory.getLogger(QuizzOrderTextChangeDaoImpl.class);

    @Override
    public Integer insert(QuizzOrdersEntity quizzOrdersEntity, long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(quizzOrdersEntity.getConsumerId());
        quizzOrdersEntity.setId(id);
        paramMap.put("mirror", quizzOrdersEntity);
        return insert("insert", paramMap);
    }

    /**
     * 修改开发者订单号
     */
    public int updateDeveloperBizId(Long consumerId, long id, String bizId) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            paramMap.put("bizId", bizId);
            return update("updateDeveloperBizId", paramMap);

        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return 0;
        }
    }

    /**
     * 修改抽奖订单主订单号
     */
    public int updateMainOrderId(Long consumerId, long id, Long mainOrderId, String mainOrderNum) {
        try {
            Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
            paramMap.put("id", id);
            paramMap.put("mainOrderId", mainOrderId);
            paramMap.put("mainOrderNum", mainOrderNum);
            int ret = update("updateMainOrderId", paramMap);

            return ret;
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return 0;
        }
    }
    
    @Override
    public QuizzOrdersEntity find(Long consumerId, Long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ_CONSUMER;
    }
}
