package cn.com.duiba.activity.center.biz.dao.quizz.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Repository;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersSimpleDao;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.support.TableHelper;

@Repository("quizzOrdersSimpleDAO")
public class QuizzOrdersSimpleDaoImpl extends ActivityBaseDao implements QuizzOrdersSimpleDao {

    /**
     * 查询用户参与活动次数
     */
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("countByConsumerIdAndOperatingActivityId", paramMap);
    }

    /**
     * 查询用户在时间段内参与活动次数
     */
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId,
                                                                  Date start, Date end) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return selectOne("countByConsumerIdAndOperatingActivityIdAndDate", paramMap);
    }

    /**
     * 查询用户免费参与活动次数
     */
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        return selectOne("countFreeByConsumerIdAndOperatingActivityId", paramMap);
    }

    /**
     * 查询用户在时间段内免费参与活动次数
     */
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId,
                                                                      Date start, Date end) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("start", start);
        paramMap.put("end", end);
        return selectOne("countFreeByConsumerIdAndOperatingActivityIdAndDate", paramMap);
    }

    /**
     * 根据ID查询订单
     */
    public QuizzOrdersEntity find(Long consumerId, Long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("id", id);
        return selectOne("find", paramMap);
    }

    /**
     * 查询用户中奖某奖项次数
     */
    public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("operatingActivityId", operatingActivityId);
        paramMap.put("prizeId", prizeId);
        return selectOne("countByConsumerIdAndPrizeId", paramMap);
    }

    /**
     * 根据活动订单ID集合查询订单信息
     */
    public List<QuizzOrdersEntity> findByIds(Long consumerId, List<Long> ids) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(consumerId);
        paramMap.put("ids", ids);
        return selectList("findByIds", paramMap);
    }
    
    @Override
	public Integer insert(QuizzOrdersEntity quizzOrdersEntity, long id) {
        Map<String, Object> paramMap = TableHelper.getTbSuffixParamsMap(quizzOrdersEntity.getConsumerId());
        quizzOrdersEntity.setId(id);
        paramMap.put("mirror", quizzOrdersEntity);
        return insert("insert", paramMap);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.QUIZZ_CONSUMER;
    }
}
