package cn.com.duiba.activity.center.biz.entity.activity;

import cn.com.duiba.activity.center.common.dto.BaseEntity;

import java.util.Date;

public class OperatingActivityEntity extends BaseEntity{

    private static final long serialVersionUID = -4272556127554154785L;

    private Long id;
	private Long appId; //appId
	private String title; //标题
	private Integer type; //活动类型 
	private Integer status; //数据状态  引用：StatusInt*
	private Long appBannerId; //首页bannerID
	private Long appItemId; //兑换项ID
	private Long consumeCredits; // 消耗的总积分数
	private Integer consumeMoney;// 消耗的总金钱数
	private Integer visitTimes; // 参与人数
	private Integer winTimes; // 中奖人数
	private Long credits; // 消耗积分数
	private Integer limitCount; // 每日最多几次
	private Integer freeLimit; // 每日免费次数
	private String rule;// 活动规则
	private String explainText; // 活动说明
	private String image; // 主图
	private String smallImage;//缩略图
	private String logo;//小图标
	private String bannerImage;//banner
	private Long activityId; //引用活动ID,  如：兑吧专题活动，兑吧单品抽奖，兑吧大转盘.....
	private Integer activityOrderQuantity; //活动订单数
	private Integer failCount; // 领取失败数量， 数据库无此字段
	private Long parentActivityId;
	private Boolean deleted; // 是否已经删除
	private Date gmtCreate; //创建时间
	private Date gmtModified; //变更时间
	private Integer creditsType;//积分模式
	private String subType;//活动模版
	private String freeScope;//免费参数次数限制类型
	private String limitScope;//参与次数限制类型
	private String rateIntroduction;	// 概率说明
	private Long customCredits;	// 抽奖积分

    public OperatingActivityEntity(){}

    public OperatingActivityEntity(Integer type){
        this.type = type;
    }
    //End chaijiangang,幸运转盘改为活动工具,2016/04/12

    public OperatingActivityEntity(boolean init4insert) {
        if (init4insert) {
            toBeInsert = true;
            consumeCredits = 0L;
            consumeMoney = 0;
            visitTimes = 0;
            winTimes = 0;
            credits = 0L;
            limitCount = 0;

            activityOrderQuantity = 0;
            deleted = false;
            gmtCreate = new Date();
            gmtModified = gmtCreate;

        }
    }

    public OperatingActivityEntity(Long id) {
        this.id = id;
        this.gmtModified=new Date();
        toBeUpdate = true;
    }
    
    public Long getId() {
        return id;
    }

    
    public void setId(Long id) {
        this.id = id;
    }

    
    public Long getAppId() {
        return appId;
    }

    
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    
    public String getTitle() {
        return title;
    }

    
    public void setTitle(String title) {
        this.title = title;
    }

    
    public Integer getType() {
        return type;
    }

    
    public void setType(Integer type) {
        this.type = type;
    }

    
    public Integer getStatus() {
        return status;
    }

    
    public void setStatus(Integer status) {
        this.status = status;
    }

    
    public Long getAppBannerId() {
        return appBannerId;
    }

    
    public void setAppBannerId(Long appBannerId) {
        this.appBannerId = appBannerId;
    }

    
    public Long getAppItemId() {
        return appItemId;
    }

    
    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    
    public Long getConsumeCredits() {
        return consumeCredits;
    }

    
    public void setConsumeCredits(Long consumeCredits) {
        this.consumeCredits = consumeCredits;
    }

    
    public Integer getConsumeMoney() {
        return consumeMoney;
    }

    
    public void setConsumeMoney(Integer consumeMoney) {
        this.consumeMoney = consumeMoney;
    }

    
    public Integer getVisitTimes() {
        return visitTimes;
    }

    
    public void setVisitTimes(Integer visitTimes) {
        this.visitTimes = visitTimes;
    }

    
    public Integer getWinTimes() {
        return winTimes;
    }

    
    public void setWinTimes(Integer winTimes) {
        this.winTimes = winTimes;
    }

    
    public Long getCredits() {
        return credits;
    }

    
    public void setCredits(Long credits) {
        this.credits = credits;
    }

    
    public Integer getLimitCount() {
        return limitCount;
    }

    
    public void setLimitCount(Integer limitCount) {
        this.limitCount = limitCount;
    }

    
    public Integer getFreeLimit() {
        return freeLimit;
    }

    
    public void setFreeLimit(Integer freeLimit) {
        this.freeLimit = freeLimit;
    }

    
    public String getRule() {
        return rule;
    }

    
    public void setRule(String rule) {
        this.rule = rule;
    }

    
    public String getExplainText() {
        return explainText;
    }

    
    public void setExplainText(String explainText) {
        this.explainText = explainText;
    }

    
    public String getImage() {
        return image;
    }

    
    public void setImage(String image) {
        this.image = image;
    }

    
    public String getSmallImage() {
        return smallImage;
    }

    
    public void setSmallImage(String smallImage) {
        this.smallImage = smallImage;
    }

    
    public String getLogo() {
        return logo;
    }

    
    public void setLogo(String logo) {
        this.logo = logo;
    }

    
    public String getBannerImage() {
        return bannerImage;
    }

    
    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    
    public Long getActivityId() {
        return activityId;
    }

    
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    
    public Integer getActivityOrderQuantity() {
        return activityOrderQuantity;
    }

    
    public void setActivityOrderQuantity(Integer activityOrderQuantity) {
        this.activityOrderQuantity = activityOrderQuantity;
    }

    
    public Integer getFailCount() {
        return failCount;
    }

    
    public void setFailCount(Integer failCount) {
        this.failCount = failCount;
    }

    
    public Long getParentActivityId() {
        return parentActivityId;
    }

    
    public void setParentActivityId(Long parentActivityId) {
        this.parentActivityId = parentActivityId;
    }

    
    public Boolean getDeleted() {
        return deleted;
    }

    
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    
    public Date getGmtCreate() {
        return gmtCreate;
    }

    
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    
    public Date getGmtModified() {
        return gmtModified;
    }

    
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    
    public Integer getCreditsType() {
        return creditsType;
    }

    
    public void setCreditsType(Integer creditsType) {
        this.creditsType = creditsType;
    }

    
    public String getSubType() {
        return subType;
    }

    
    public void setSubType(String subType) {
        this.subType = subType;
    }

    
    public String getFreeScope() {
        return freeScope;
    }

    
    public void setFreeScope(String freeScope) {
        this.freeScope = freeScope;
    }

    
    public String getLimitScope() {
        return limitScope;
    }

    
    public void setLimitScope(String limitScope) {
        this.limitScope = limitScope;
    }

    
    public String getRateIntroduction() {
        return rateIntroduction;
    }

    
    public void setRateIntroduction(String rateIntroduction) {
        this.rateIntroduction = rateIntroduction;
    }

    
    public Long getCustomCredits() {
        return customCredits;
    }

    
    public void setCustomCredits(Long customCredits) {
        this.customCredits = customCredits;
    }


    @Override
    public String toString() {
        return "OperatingActivityEntity [id=" + id + ", appId=" + appId + ", title=" + title + ", type=" + type
               + ", status=" + status + ", appBannerId=" + appBannerId + ", appItemId=" + appItemId
               + ", consumeCredits=" + consumeCredits + ", consumeMoney=" + consumeMoney + ", visitTimes=" + visitTimes
               + ", winTimes=" + winTimes + ", credits=" + credits + ", limitCount=" + limitCount + ", freeLimit="
               + freeLimit + ", rule=" + rule + ", explainText=" + explainText + ", image=" + image + ", smallImage="
               + smallImage + ", logo=" + logo + ", bannerImage=" + bannerImage + ", activityId=" + activityId
               + ", activityOrderQuantity=" + activityOrderQuantity + ", failCount=" + failCount
               + ", parentActivityId=" + parentActivityId + ", deleted=" + deleted + ", gmtCreate=" + gmtCreate
               + ", gmtModified=" + gmtModified + ", creditsType=" + creditsType + ", subType=" + subType
               + ", freeScope=" + freeScope + ", limitScope=" + limitScope + ", rateIntroduction=" + rateIntroduction
               + ", customCredits=" + customCredits + "]";
    }


}
