package cn.com.duiba.activity.center.biz.remoteservice.impl.quizz;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.activity.center.api.remoteservice.quizz.RemoteQuizzOrdersStatusChangeService;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzOrdersStatusChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;

@Service
public class RemoteQuizzOrdersStatusChangeServiceImpl implements
		RemoteQuizzOrdersStatusChangeService {
	@Autowired
	private QuizzOrdersStatusChangeService quizzOrdersStatusChangeService;

	@Override
	public int updateExchangeStatusToFail(Long consumerId, long id,
			String error4admin, String error4developer, String error4consumer) {
		return quizzOrdersStatusChangeService.updateExchangeStatusToFail(consumerId, id, error4admin, error4developer, error4consumer);
	}

	@Override
	public int updateExchangeStatusToOverdue(long id, long consumerId, String error4admin,
			String error4developer, String error4consumer) {
		return quizzOrdersStatusChangeService.updateExchangeStatusToOverdue(id, consumerId, error4admin, error4developer, error4consumer);
	}

	@Override
	public int updateStatusToFail(Long consumerId, long id, String error4admin,
			String error4developer, String error4consumer) {
		return quizzOrdersStatusChangeService.updateStatusToFail(consumerId, id, error4admin, error4developer, error4consumer);
	}

	@Override
	public Integer doTakePrize(Long consumerId, Long id) {
		return quizzOrdersStatusChangeService.doTakePrize(consumerId, id);
	}

	@Override
	public Integer rollbackTakePrize(Long consumerId, Long id) {
		return quizzOrdersStatusChangeService.rollbackTakePrize(consumerId, id);
	}

	@Override
	public Integer updateLotteryResult(Long consumerId, Long id,
			Long appItemId, Long itemId, Long prizeId, String prizeName,
			String prizeType, String prizeFacePrice, Long couponId) {
		return quizzOrdersStatusChangeService.updateLotteryResult(consumerId, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId);
	}

	@Override
	public Integer updateLotteryLuckResult(Long consumerId, Long id,
			Long appItemId, Long itemId, Long prizeId, String prizeName,
			String prizeType, String prizeFacePrice, Long couponId) {
		return quizzOrdersStatusChangeService.updateLotteryLuckResult(consumerId, id, appItemId, itemId, prizeId, prizeName, prizeType, prizeFacePrice, couponId);
	}
	
	@Override
    public QuizzOrdersDto insert(QuizzOrdersDto quizzOrdersDto, long id){
		quizzOrdersStatusChangeService.insert(quizzOrdersDto, id);
		return quizzOrdersDto;
    }
    
    @Override
    public QuizzOrdersDto find(Long consumerId, Long id){
    	QuizzOrdersDto quizzOrdersDto = quizzOrdersStatusChangeService.find(consumerId, id);
    	return quizzOrdersDto;
    }

}
