package cn.com.duiba.activity.center.biz.remoteservice.impl.singlelottery;

import cn.com.duiba.activity.center.api.dto.DeveloperActivityStatisticsDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryOrderDto;
import cn.com.duiba.activity.center.api.remoteservice.singlelottery.RemoteSingleLotteryOrderService;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryOrderService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by yansen on 16/6/24.
 */
public class RemoteSingleLotteryOrderServiceImpl implements RemoteSingleLotteryOrderService{

    @Autowired
    private SingleLotteryOrderService singleLotteryOrderService;

    /**
     * 根据ID查询单品抽奖订单
     *
     * @param id
     */
    @Override
    public SingleLotteryOrderDto find(Long id) {
        return BeanUtils.copy(singleLotteryOrderService.find(id),SingleLotteryOrderDto.class);
    }

    /**
     * 统计奖项用户中奖次数
     *
     * @param activityId
     * @param consumerId
     * @param optionType
     */
    @Override
    public Integer countByConsumerIdAndOptionType(Long activityId, Long consumerId, Integer optionType) {
        return singleLotteryOrderService.countByConsumerIdAndOptionType(activityId,consumerId,optionType);
    }

    /**
     * 根据ID集合查询订单
     *
     * @param ids
     */
    @Override
    public List<SingleLotteryOrderDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(singleLotteryOrderService.findAllByIds(ids),SingleLotteryOrderDto.class);
    }

    /**
     * 查询当前用户在当前活动当前APP的抽奖次数
     *
     * @param activityId
     * @param appId
     * @param consumerId
     */
    @Override
    public Integer findLotteryCountByComsumer(Long activityId, Long appId, Long consumerId) {
        return singleLotteryOrderService.findLotteryCountByComsumer(activityId,appId,consumerId);
    }

    /**
     * 查询当天当前用户在当前活动当前APP的抽奖次数
     *
     * @param activityId
     * @param appId
     * @param consumerId
     * @param statTime
     * @param endTime
     */
    @Override
    public Integer findCountByComsumerTime(Long activityId, Long appId, Long consumerId, Date statTime, Date endTime) {
        return singleLotteryOrderService.findCountByComsumerTime(activityId,appId,consumerId,statTime,endTime);
    }

    /**
     * 查询前台显示5条中奖名单
     *
     * @param activityId
     * @param appId
     */
    @Override
    public List<SingleLotteryOrderDto> findFrontLotteryList(Long activityId, Long appId) {
        return BeanUtils.copyList(singleLotteryOrderService.findFrontLotteryList(activityId,appId),SingleLotteryOrderDto.class);
    }

    /**
     * 根据上游订单号查单
     *
     * @param appId
     * @param bizId
     */
    @Override
    public SingleLotteryOrderDto findByAppAndDeveloperBizId(Long appId, String bizId) {
        return BeanUtils.copy(singleLotteryOrderService.findByAppAndDeveloperBizId(appId,bizId),SingleLotteryOrderDto.class);
    }

    /**
     * 根据订单ID查询订单信息
     *
     * @param ids
     */
    @Override
    public List<SingleLotteryOrderDto> findByIds(List<Long> ids) {
        return BeanUtils.copyList(singleLotteryOrderService.findByIds(ids),SingleLotteryOrderDto.class);
    }

    /**
     * 根据主订单ID集合查询单品订单
     *
     * @param ids
     */
    @Override
    public List<SingleLotteryOrderDto> findByInOrderIds(List<Long> ids) {
        return BeanUtils.copyList(singleLotteryOrderService.findByInOrderIds(ids),SingleLotteryOrderDto.class);
    }

    /**
     * 查询创建时间小于 PARAM的订单
     * 扫描24小时没有领奖的订单，查询较慢，待优化
     */
    @Override
    public List<SingleLotteryOrderDto> findAllByLtGmtCreateAndExchangeStatus() {
        return BeanUtils.copyList(singleLotteryOrderService.findAllByLtGmtCreateAndExchangeStatus(),SingleLotteryOrderDto.class);
    }

    /**
     * 获取失败订单数
     *
     * @param operatingActivityIds
     */
    @Override
    public List<DeveloperActivityStatisticsDto> findFailCountByOperatingActivityIds(List<Long> operatingActivityIds) {
        return BeanUtils.copyList(singleLotteryOrderService.findFailCountByOperatingActivityIds(operatingActivityIds),DeveloperActivityStatisticsDto.class);
    }

    /**
     * 单品抽奖订单分页
     *
     * @param paramMap
     */
    @Override
    public List<SingleLotteryOrderDto> findByLimit(Map<String, Object> paramMap) {
        return BeanUtils.copyList(singleLotteryOrderService.findByLimit(paramMap),SingleLotteryOrderDto.class);
    }

    /**
     * 单品抽奖订单分页条数
     *
     * @param paramMap
     */
    @Override
    public Long findByCount(Map<String, Object> paramMap) {
        return singleLotteryOrderService.findByCount(paramMap);
    }

    /**
     * 根据奖项类型查询中奖人数
     *
     * @param operatingActivityIds
     * @param statTime
     * @param endTime
     * @param optionType
     */
    @Override
    public Integer countWintimesByOptionType(List<Long> operatingActivityIds, Date statTime, Date endTime, Integer optionType) {
        return singleLotteryOrderService.countWintimesByOptionType(operatingActivityIds,statTime,endTime,optionType);
    }

    /**
     * 根据开发者单品活动ID列表得到活动ID对中大奖人数的Map
     *
     * @param operatingActivityIds
     */
    @Override
    public List<SingleLotteryOrderDto> getWinningListByOperatingActivityIds(Collection<Long> operatingActivityIds) {
        return BeanUtils.copyList(singleLotteryOrderService.getWinningListByOperatingActivityIds(operatingActivityIds),SingleLotteryOrderDto.class);
    }

    /**
     * 修改订单领奖状态为失败
     *
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     */
    @Override
    public int updateExchangeStatusToFail(long id, String error4admin, String error4developer, String error4consumer) {
        return singleLotteryOrderService.updateExchangeStatusToFail(id,error4admin,error4developer,error4consumer);
    }

    /**
     * 修改订单领奖状态为过期失效
     *
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     */
    @Override
    public int updateExchangeStatusToOverdue(long id, String error4admin, String error4developer, String error4consumer) {
        return singleLotteryOrderService.updateExchangeStatusToOverdue(id,error4admin,error4developer,error4consumer);
    }

    /**
     * 修改订单状态成功，领奖状态待领奖
     *
     * @param id
     */
    @Override
    public int updateStatusToSuccess(long id) {
        return singleLotteryOrderService.updateStatusToSuccess(id);
    }

    /**
     * 修改订单状态失败
     *
     * @param id
     * @param error4admin
     * @param error4developer
     * @param error4consumer
     */
    @Override
    public int updateStatusToFail(long id, String error4admin, String error4developer, String error4consumer) {
        return singleLotteryOrderService.updateStatusToFail(id,error4admin,error4developer,error4consumer);
    }

    /**
     * 订单抽奖失败，修改为未中奖
     *
     * @param id
     */
    @Override
    public int updatePrizeTypeToThanks(long id) {
        return singleLotteryOrderService.updatePrizeTypeToThanks(id);
    }

    /**
     * 处理领奖
     *
     * @param id
     */
    @Override
    public Integer doTakePrize(Long id) {
        return singleLotteryOrderService.doTakePrize(id);
    }

    /**
     * 领奖创建主订单失败回滚领奖
     *
     * @param id
     */
    @Override
    public Integer rollbackTakePrize(Long id) {
        return singleLotteryOrderService.rollbackTakePrize(id);
    }

    /**
     * 修改订单抽奖结果
     *
     * @param id
     * @param appItemId
     * @param itemId
     * @param prizeName
     * @param prizeType
     * @param prizeDegree
     * @param prizeFacePrice
     * @param optionType
     * @param couponId
     */
    @Override
    public Integer updateLotteryResult(Long id, Long appItemId, Long itemId, String prizeName, String prizeType, String prizeDegree, Integer prizeFacePrice, Integer optionType, Long couponId) {
        return singleLotteryOrderService.updateLotteryResult(id,appItemId,itemId,prizeName,prizeType,prizeDegree,prizeFacePrice,optionType,couponId);
    }

    /**
     * 修改开发者订单号
     *
     * @param id
     * @param bizId
     */
    @Override
    public int updateDeveloperBizId(long id, String bizId) {
        return singleLotteryOrderService.updateDeveloperBizId(id,bizId);
    }

    /**
     * 修改主订单ID
     *
     * @param id
     * @param orderId
     */
    @Override
    public int updateMainOrderId(long id, Long orderId) {
        return singleLotteryOrderService.updateMainOrderId(id,orderId);
    }

    /**
     * 新增单品抽奖订单
     *
     * @param singleLotteryOrderDO
     */
    @Override
    public void insert(SingleLotteryOrderDto singleLotteryOrderDO) {
        singleLotteryOrderService.insert(singleLotteryOrderDO);
    }
}
