package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerAppSpecifyDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerAppSpecifyDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerAppSpecifyEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerAppSpecifyService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/5/24.
 */
@Service
public class DuibaQuestionAnswerAppSpecifyServiceImpl implements DuibaQuestionAnswerAppSpecifyService {
    @Resource
    private DuibaQuestionAnswerAppSpecifyDao duibaQuestionAnswerAppSpecifyDao;

    @Override
    public DuibaQuestionAnswerAppSpecifyDto findByQuestionAnswerIdAndAppId(Long questionId, Long appId) {
        return BeanUtils.copy(duibaQuestionAnswerAppSpecifyDao.findByQuestionAnswerIdAndAppId(questionId, appId), DuibaQuestionAnswerAppSpecifyDto.class);
    }

    @Override
    public List<DuibaQuestionAnswerAppSpecifyDto> findByDuibaQuestionAnswerId(Long duibaQuestionAnswerId) {
        return BeanUtils.copyList(duibaQuestionAnswerAppSpecifyDao.findByDuibaQuestionAnswerId(duibaQuestionAnswerId), DuibaQuestionAnswerAppSpecifyDto.class);
    }

    @Override
    public void delete(Long id) {
        duibaQuestionAnswerAppSpecifyDao.delete(id);
    }

    @Override
    public void insert(DuibaQuestionAnswerAppSpecifyDto duibaQuestionAnswerAppSpecify) {
        DuibaQuestionAnswerAppSpecifyEntity e = BeanUtils.copy(duibaQuestionAnswerAppSpecify, DuibaQuestionAnswerAppSpecifyEntity.class);
        duibaQuestionAnswerAppSpecifyDao.insert(e);
        duibaQuestionAnswerAppSpecify.setId(e.getId());
    }

    @Override
    public DuibaQuestionAnswerAppSpecifyDto find(Long id) {
        return BeanUtils.copy(duibaQuestionAnswerAppSpecifyDao.find(id), DuibaQuestionAnswerAppSpecifyDto.class);
    }
}
