package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOptionsDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOptionsEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOptionsService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/5/31.
 */
@Service
public class DuibaQuestionAnswerOptionsServiceImpl implements DuibaQuestionAnswerOptionsService {
    @Resource
    private DuibaQuestionAnswerOptionsDao duibaQuestionAnswerOptionsDao;

    @Override
    public List<DuibaQuestionAnswerOptionsDto> findOptionsByQuestionId(Long duibaQuestionId) {
        return BeanUtils.copyList(duibaQuestionAnswerOptionsDao.findOptionsByQuestionId(duibaQuestionId), DuibaQuestionAnswerOptionsDto.class);
    }

    @Override
    public DuibaQuestionAnswerOptionsDto find(Long id) {
        return BeanUtils.copy(duibaQuestionAnswerOptionsDao.find(id), DuibaQuestionAnswerOptionsDto.class);
    }

    @Override
    public DuibaQuestionAnswerOptionsDto findById(Long id) {
        return BeanUtils.copy(duibaQuestionAnswerOptionsDao.findById(id), DuibaQuestionAnswerOptionsDto.class);
    }

    @Override
    public int delete(List<Long> ids) {
        return duibaQuestionAnswerOptionsDao.delete(ids);
    }

    @Override
    public void insert(DuibaQuestionAnswerOptionsDto questionAnswerOptionsDO) {
        DuibaQuestionAnswerOptionsEntity e = BeanUtils.copy(questionAnswerOptionsDO, DuibaQuestionAnswerOptionsEntity.class);
        duibaQuestionAnswerOptionsDao.insert(e);
        questionAnswerOptionsDO.setId(e.getId());
    }

    @Override
    public int update(DuibaQuestionAnswerOptionsDto questionAnswerOptionsDO) {
        return duibaQuestionAnswerOptionsDao.update(BeanUtils.copy(questionAnswerOptionsDO, DuibaQuestionAnswerOptionsEntity.class));
    }

}
