package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOrdersExtraDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerOrdersExtraDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerOrdersExtraEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOrdersExtraService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by wenqi.huang on 16/6/3.
 */
@Service
public class DuibaQuestionAnswerOrdersExtraServiceImpl implements DuibaQuestionAnswerOrdersExtraService {
    @Resource
    private DuibaQuestionAnswerOrdersExtraDao duibaQuestionAnswerOrdersExtraDao;

    @Override
    public int insert(DuibaQuestionAnswerOrdersExtraDto duibaQuestionAnswerOrdersExtraDO) {
        DuibaQuestionAnswerOrdersExtraEntity e = BeanUtils.copy(duibaQuestionAnswerOrdersExtraDO,DuibaQuestionAnswerOrdersExtraEntity.class);
        int ret = duibaQuestionAnswerOrdersExtraDao.insert(e);
        duibaQuestionAnswerOrdersExtraDO.setId(e.getId());
        return ret;
    }

    @Override
    public DuibaQuestionAnswerOrdersExtraDto find(Long ordersExtraId) {
        return BeanUtils.copy(duibaQuestionAnswerOrdersExtraDao.find(ordersExtraId), DuibaQuestionAnswerOrdersExtraDto.class);
    }

    @Override
    public int update(Long ordersExtraId, String answerData, Integer rightCount) {
        return duibaQuestionAnswerOrdersExtraDao.update(ordersExtraId, answerData, rightCount);
    }

    @Override
    public DuibaQuestionAnswerOrdersExtraDto findByQuestionOrderId(Long questionOrderId) {
        return BeanUtils.copy(duibaQuestionAnswerOrdersExtraDao.findByQuestionOrderId(questionOrderId), DuibaQuestionAnswerOrdersExtraDto.class);
    }
}
