package cn.com.duiba.activity.center.biz.service.game.impl;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionRecordDto;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionRecordDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionRecordEntity;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionRecordService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/3.
 */
@Service
public class DuibaQuestionRecordServiceImpl implements DuibaQuestionRecordService {
    @Resource
    private DuibaQuestionRecordDao duibaQuestionRecordDao;

    @Override
    public List<DuibaQuestionRecordDto> findByBankIdAndLimit(Long qBankId, Integer limit) {
        return BeanUtils.copyList(duibaQuestionRecordDao.findByBankIdAndLimit(qBankId, limit), DuibaQuestionRecordDto.class);
    }

    @Override
    public void insert(DuibaQuestionRecordDto questionRecordDO) {
        DuibaQuestionRecordEntity e = BeanUtils.copy(questionRecordDO, DuibaQuestionRecordEntity.class);
        duibaQuestionRecordDao.insert(e);
        questionRecordDO.setId(e.getId());
    }

    @Override
    public List<DuibaQuestionRecordDto> findByPage(Long questionBankId, Integer offset, Integer max) {
        return BeanUtils.copyList(duibaQuestionRecordDao.findByPage(questionBankId, offset, max), DuibaQuestionRecordDto.class);
    }

    @Override
    public Long findCountByBankIdsStr(List<String> bankIds) {
        return duibaQuestionRecordDao.findCountByBankIdsStr(bankIds);
    }

    @Override
    public DuibaQuestionRecordDto findById(Long id) {
        return BeanUtils.copy(duibaQuestionRecordDao.findById(id), DuibaQuestionRecordDto.class);
    }

    @Override
    public Long findTotalCount(Long questionBankId) {
        return duibaQuestionRecordDao.findTotalCount(questionBankId);
    }

    @Override
    public int delete(Long id) {
        return duibaQuestionRecordDao.delete(id);
    }
}
