package cn.com.duiba.activity.center.biz.service.ngame.impl;

import cn.com.duiba.activity.center.api.dto.ngame.DuibaNgameOptionsDto;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameOptionsDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameOptionsEntity;
import cn.com.duiba.activity.center.biz.service.ngame.DuibaNgameOptionsService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/15.
 */
@Service
public class DuibaNgameOptionsServiceImpl implements DuibaNgameOptionsService {
    @Resource
    private DuibaNgameOptionsDao duibaNgameOptionsDao;

    public void update(DuibaNgameOptionsDto duibaNgameOptionsDto) {
        duibaNgameOptionsDao.update(BeanUtils.copy(duibaNgameOptionsDto, DuibaNgameOptionsEntity.class));
    }

    public void addBatch(List<DuibaNgameOptionsDto> list) {
        duibaNgameOptionsDao.addBatch(BeanUtils.copyList(list, DuibaNgameOptionsEntity.class));
    }

    public void add(DuibaNgameOptionsDto duibaNgameOptionsDto) {
        DuibaNgameOptionsEntity e = BeanUtils.copy(duibaNgameOptionsDto, DuibaNgameOptionsEntity.class);
        duibaNgameOptionsDao.add(e);
        duibaNgameOptionsDto.setId(e.getId());
    }

    @Override
    public List<DuibaNgameOptionsDto> findByGameId(Long duibaNgameId) {
        return BeanUtils.copyList(duibaNgameOptionsDao.findByGameId(duibaNgameId), DuibaNgameOptionsDto.class);
    }

    @Override
    public void delete(Long id) {
        duibaNgameOptionsDao.delete(id);
    }

    @Override
    public Integer countBigPrizeByGameId(Long duibaNgameId) {
        return duibaNgameOptionsDao.countBigPrizeByGameId(duibaNgameId);
    }

    @Override
    public DuibaNgameOptionsDto find(Long id) {
        return BeanUtils.copy(duibaNgameOptionsDao.find(id), DuibaNgameOptionsDto.class);
    }

    @Override
    public List<DuibaNgameOptionsDto> findByAutoOpen(Long ngameId, boolean autoOpen) {
        return BeanUtils.copyList(duibaNgameOptionsDao.findByAutoOpen(ngameId, autoOpen), DuibaNgameOptionsDto.class);
    }

    @Override
    public List<DuibaNgameOptionsDto> findByAutoOpenDesc(Long ngameId, boolean autoOpen) {
        return BeanUtils.copyList(duibaNgameOptionsDao.findByAutoOpenDesc(ngameId, autoOpen), DuibaNgameOptionsDto.class);
    }

    @Override
    public List<DuibaNgameOptionsDto> findDisplayOption(Long ngameId) {
        return BeanUtils.copyList(duibaNgameOptionsDao.findDisplayOption(ngameId), DuibaNgameOptionsDto.class);
    }
}
