package cn.com.duiba.activity.center.biz.service.quizz.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockDto;
import cn.com.duiba.activity.center.biz.dao.quizz.DuibaQuizzStockDao;
import cn.com.duiba.activity.center.biz.entity.quizz.DuibaQuizzStockEntity;
import cn.com.duiba.activity.center.biz.service.quizz.DuibaQuizzStockService;
import cn.com.duiba.wolf.utils.BeanUtils;

@Service
public class DuibaQuizzStockServiceImpl implements DuibaQuizzStockService {
	@Autowired
	private DuibaQuizzStockDao DuibaQuizzStockDao;

	@Override
	public int subStock(Long id, Integer subNumber) {
		return DuibaQuizzStockDao.subStock(id, subNumber);
	}

	@Override
	public int addStock(Long id, Integer addNumber) {
		return DuibaQuizzStockDao.addStock(id, addNumber);
	}

	@Override
	public DuibaQuizzStockDto findRemaining(Long optionId) {
		return BeanUtils.copy(DuibaQuizzStockDao.findRemaining(optionId), DuibaQuizzStockDto.class);
	}

	@Override
	public DuibaQuizzStockDto findByQuizzOptionId(Long questionOptionId) {
		return BeanUtils.copy(DuibaQuizzStockDao.findByQuizzOptionId(questionOptionId), DuibaQuizzStockDto.class);
	}

	@Override
	public List<DuibaQuizzStockDto> findByQuizzOptionIds(List<Long> list) {
		return BeanUtils.copyList(DuibaQuizzStockDao.findByQuizzOptionIds(list), DuibaQuizzStockDto.class);
	}

	@Override
	public int updateStockAdd(Long id, Integer stockAdd) {
		return DuibaQuizzStockDao.updateStockAdd(id, stockAdd);
	}

	@Override
	public int updateStockSub(Long id, Integer stockSub) {
		return DuibaQuizzStockDao.updateStockSub(id, stockSub);
	}

	@Override
	public void add(DuibaQuizzStockDto quizzStockDto) {
		DuibaQuizzStockEntity entity = BeanUtils.copy(quizzStockDto, DuibaQuizzStockEntity.class);
		DuibaQuizzStockDao.add(entity);
		quizzStockDto.setId(entity.getId());
	}

	@Override
	public void addBatch(List<DuibaQuizzStockDto> list) {
		DuibaQuizzStockDao.addBatch(BeanUtils.copyList(list, DuibaQuizzStockEntity.class));
	}

}
