package cn.com.duiba.activity.center.biz.service.quizz.impl;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import cn.com.duiba.activity.center.api.dto.quizz.QuizzOrdersDto;
import cn.com.duiba.activity.center.biz.dao.quizz.QuizzOrdersStatusChangeDao;
import cn.com.duiba.activity.center.biz.entity.quizz.QuizzOrdersEntity;
import cn.com.duiba.activity.center.biz.kafka.QuizzMQSend;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzOrdersStatusChangeService;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.google.common.base.Preconditions;

/**
 * Created by xuezhaoming on 16/6/8.
 */
@Service
public class QuizzOrdersStatusChangeServiceImpl implements QuizzOrdersStatusChangeService {

    @Resource
    private QuizzOrdersStatusChangeDao quizzOrdersStatusChangeDao;

    @Resource
    private QuizzMQSend                quizzMQSend;

    @Override
    public int updateExchangeStatusToFail(Long consumerId, long id, String error4admin, String error4developer,
                                          String error4consumer) {

        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        int ret = quizzOrdersStatusChangeDao.updateExchangeStatusToFail(consumerId, id, error4admin, error4developer,
                                                                        error4consumer);
        if (ret == 1) {
            quizzMQSend.quizzSendDataSync(consumerId, id);
        }

        return ret;
    }

    @Override
    public int updateExchangeStatusToOverdue(long id, long consumerId, String error4admin, String error4developer, String error4consumer) {
        Preconditions.checkNotNull(id, "id is null ");

        int ret = quizzOrdersStatusChangeDao.updateExchangeStatusToOverdue(id, consumerId,
                                                                           error4admin, error4developer, error4consumer);
        if (ret == 1) {
            quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public int updateStatusToFail(Long consumerId, long id, String error4admin, String error4developer,
                                  String error4consumer) {
        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        int ret = quizzOrdersStatusChangeDao.updateStatusToFail(consumerId, id, error4admin, error4developer,
                                                                error4consumer);
        if (ret == 1) {
            quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public Integer doTakePrize(Long consumerId, Long id) {
        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(id, "id is null ");

        int ret = quizzOrdersStatusChangeDao.doTakePrize(consumerId, id);
        if (ret == 1) {
            quizzMQSend.quizzSendDataSync(consumerId, id);
        }

        return ret;
    }

    @Override
    public Integer rollbackTakePrize(Long consumerId, Long id) {
        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(id, "id is null ");

        int ret = quizzOrdersStatusChangeDao.rollbackTakePrize(consumerId, id);
        if (ret == 1) {
            quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }

    @Override
    public Integer updateLotteryResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId,
                                       String prizeName, String prizeType, String prizeFacePrice, Long couponId) {

        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(id, "id is null ");

        int ret = quizzOrdersStatusChangeDao.updateLotteryResult(consumerId, id, appItemId, itemId, prizeId, prizeName,
                                                                 prizeType, prizeFacePrice, couponId);
        if (ret == 1) {
            quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;

    }

    @Override
    public Integer updateLotteryLuckResult(Long consumerId, Long id, Long appItemId, Long itemId, Long prizeId,
                                           String prizeName, String prizeType, String prizeFacePrice, Long couponId) {
        Preconditions.checkNotNull(consumerId, "consumerId is null ");
        Preconditions.checkNotNull(id, "id is null ");

        int ret = quizzOrdersStatusChangeDao.updateLotteryLuckResult(consumerId, id, appItemId, itemId, prizeId,
                                                                     prizeName, prizeType, prizeFacePrice, couponId);

        if (ret == 1) {
            quizzMQSend.quizzSendDataSync(consumerId, id);
        }
        return ret;
    }
    
    @Override
    public Integer insert(QuizzOrdersDto quizzOrdersDto, long id){
    	QuizzOrdersEntity entity = BeanUtils.copy(quizzOrdersDto, QuizzOrdersEntity.class);
    	int num = quizzOrdersStatusChangeDao.insert(entity, id);
    	quizzOrdersDto.setId(id);
    	return num;
    }
    
    @Override
    public QuizzOrdersDto find(Long consumerId, Long id){
    	QuizzOrdersEntity entity = quizzOrdersStatusChangeDao.find(consumerId, id);
    	return BeanUtils.copy(entity, QuizzOrdersDto.class);
    }
}
