package cn.com.duiba.activity.center.biz.service.singlelottery.impl;

import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;
import cn.com.duiba.activity.center.biz.dao.singlelottery.SingleLotteryDao;
import cn.com.duiba.activity.center.biz.entity.singlelottery.AppSingleLotteryEntity;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryService;
import cn.com.duiba.wolf.utils.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by yansen on 16/6/20.
 */
@Service
public class SingleLotteryServiceImpl implements SingleLotteryService{
    @Resource
    private SingleLotteryDao singleLotteryDao;

    @Override
    public AppSingleLotteryDto find(Long id) {
        return BeanUtils.copy(singleLotteryDao.find(id),AppSingleLotteryDto.class);
    }

    @Override
    public AppSingleLotteryDto findForupdate(Long id) {
        return BeanUtils.copy(singleLotteryDao.findForupdate(id),AppSingleLotteryDto.class);
    }

    @Override
    public List<AppSingleLotteryDto> findAllByIds(List<Long> ids) {
        return BeanUtils.copyList(singleLotteryDao.findAllByIds(ids),AppSingleLotteryDto.class);
    }

    @Override
    public int addMainAppItemRemainingById(Long id, Integer addMainAppItemRemaining) {
        return singleLotteryDao.addMainAppItemRemainingById(id, addMainAppItemRemaining);
    }

    @Override
    public int subMainAppItemRemainingById(Long id, Integer subMainAppItemRemaining) {
        return singleLotteryDao.subMainAppItemRemainingById(id, subMainAppItemRemaining);
    }

    @Override
    public Integer findRemaingForupdate(Long id) {
        return singleLotteryDao.findRemaingForupdate(id);
    }

    @Override
    public void insert(AppSingleLotteryDto appSingleLotteryDto) {
        AppSingleLotteryEntity entity=new AppSingleLotteryEntity(true);
        BeanUtils.copy(appSingleLotteryDto,entity);
        singleLotteryDao.insert(entity);
        appSingleLotteryDto.setId(entity.getId());
    }

    @Override
    public int update(AppSingleLotteryDto appSingleLotteryDto) {
        return singleLotteryDao.update(BeanUtils.copy(appSingleLotteryDto,AppSingleLotteryEntity.class));
    }

    @Override
    public int reduceMainAppItemRemaining(Long id) {
        return singleLotteryDao.reduceMainAppItemRemaining(id);
    }

    @Override
    public int addMainAppItemRemaining(Long id) {
        return singleLotteryDao.addMainAppItemRemaining(id);
    }

    @Override
    public int updateForDevEdit(AppSingleLotteryDto appSingleLottery) {
        return singleLotteryDao.updateForDevEdit(BeanUtils.copy(appSingleLottery,AppSingleLotteryEntity.class));
    }
}
