package cn.com.duiba.activity.center.biz.support;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

/**
 * 定义缓存的key,为了防止和其他项目中的key重复,在每个值前面加上子模块名前缀 Created by wenqi.huang on 16/4/25.
 */
public class CacheConstants {

    /**
     * 用户consumer的缓存key
     */
    public static final String MS_CONSUMER_CACHE                    = "chaos.consumer_Id_";

    public static final String KEY_APP                              = "chaos.key_appId_";
    public static final String FIRST_APP_OF_DEV_ID                  = "chaos.firstAppOfDevId_";
    public static final String KEP_APP_BANNERS                      = "chaos.keyAppBanners_";
    public static final String KEY_DEVELOPER                        = "chaos.keyDeveloperId_";
    public static final String KEY_APP_BANNER_BY_ID                 = "chaos.keyAppBannerById_";
    public static final String KEY_APP_LAYOUT_BY_APPID              = "chaos.keyAppLayoutByAppId_";
    public static final String KEY_APP_VIP_LIMIT_BY_APPID           = "chaos.keyAppVipLimitByAppId_";
    public static final String KEY_APP_LAYOUT_BRICK_SIMPLE_BY_ID    = "chaos.keyAppLayoutSimpleById_";
    public static final String KEY_APP_LAYOUT_BRICK_CONTENT_BY_ID   = "chaos.keyAppLayoutContentById_";
    public static final String KEY_APP_EXTRA_SIMPLE_BY_APP_ID       = "chaos.keyAppExtraSimpleByAppId_";
    public static final String KEY_APP_EXTRA_PROGRAM_BY_APP_ID      = "chaos.keyAppExtraProgramByAppId_";
    public static final String KEY_CONSUMER_FOOTPRINT_BY_CONSUMERID = "chaos.consumerFootprintByCconsumerid_";
    public static final String KEY_APP_MANUAL_LOTTERY_BY_ID         = "activity.appManualLotteryById_";
    /**
     * 黑名单的缓存key
     */
    public static final String KEY_BLACK                            = "chaos.black_";

    // 不允许存在相同的静态常量,这里做判断,如果有相同的就抛出异常
    static {
        Field[] fields = CacheConstants.class.getFields();
        Set<String> set = new HashSet<String>();
        for (Field f : fields) {
            try {
                boolean success = set.add(f.get(null) + "_" + f.getType().getName());
                if (!success) {
                    throw new RuntimeException("duplicated value: [" + f.get(null) + "] ,please modify one of them");
                }
            } catch (IllegalAccessException e) {
                // Ignore
            }
        }
    }

}
