package cn.com.duiba.activity.center.biz.support;

/**
 * Created by xuezhaoming on 16/5/20.<br/>
 * 库存中心redis key 工厂
 */
public final class RedisKeyFactory {

    private static final String STOCK_PREFIX      = "stock_";

    private static final String LOCK_PREFIX       = "_lock";

    private static final String SELL_OUT          = "_sellout";

    private static final String IDEMPOTENT_PREFIX = "idep_";

    /**
     * 生成库存key
     * 
     * @param storkID 库存ID
     * @return 在redis中存储的key
     */
    public static String stockKey(long storkID) {
        return STOCK_PREFIX + storkID;
    }

    /**
     * 生成库存锁key
     * 
     * @param storkID 库存ID
     * @return 在redis中存储的key
     */
    public static String stockKeyLock(long storkID) {
        return STOCK_PREFIX + storkID + LOCK_PREFIX;
    }

    /**
     * 生成搜卖完key
     * 
     * @param storkID 库存ID
     * @return 在redis中存储的key
     */
    public static String stockSellOutFlagKey(long storkID) {
        return STOCK_PREFIX + storkID + SELL_OUT;
    }

    /**
     * 幂等key参数
     * 
     * @param stockId
     * @param reqBiz
     * @param operation
     * @return
     */
    public static String idempotentKey(long stockId, String reqBiz, String operation) {
        return IDEMPOTENT_PREFIX + stockId + reqBiz + operation;
    }
}
