package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionAnswerDao;
import cn.com.duiba.activity.center.biz.entity.ActivityExtraInfoEntity;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionAnswerEntity;
import org.springframework.stereotype.Repository;

import java.util.*;

@Repository
public class DuibaQuestionAnswerDaoImpl extends ActivityBaseDao implements DuibaQuestionAnswerDao {

	@Override
	public DuibaQuestionAnswerEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}
	@Override
	public List<DuibaQuestionAnswerEntity> findAutoOff() {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("nowTime", new Date());
		return selectList("findAutoOff", paramMap);
	}

	@Override
	public int updateStatus(Long id, Integer status) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("status", status);
		return update("updateStatus", paramMap);
	}

	@Override
	public List<DuibaQuestionAnswerEntity> findByIds(List<Long> ids) {
		if(ids.isEmpty()){
			return Collections.emptyList();
		}
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ids", ids);
		return selectList("findByIds", paramMap);
	}

	@Override
	public ActivityExtraInfoEntity findExtraInfoById(Long id) {
		return selectOne("findExtraInfoById",id);
	}


	@Override
	public List<DuibaQuestionAnswerEntity> findAllByIds(List<Long> ids) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ids", ids);
		return selectList("findAllByIds", paramMap);
	}

	@Override
	public List<AddActivityEntity> findAllQuestion(Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		return selectList("findAllQuestion", paramMap);
	}



	@Override
	public List<DuibaQuestionAnswerEntity> findByPage(Integer offset, Integer max) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("offset", offset);
		paramMap.put("max", max);
		return selectList("findByPage", paramMap);
	}

	@Override
	public List<DuibaQuestionAnswerEntity> findByPage(Map<String, Object> paramMap) {
		return selectList("findByPage", paramMap);
	}

	@Override
	public Long findPageCount() {
		return selectOne("findPageCount");
	}

	@Override
	public Long findPageCount(Map<String, Object> paramMap) {
		return selectOne("findPageCount",paramMap);
	}

	@Override
	public int delete(Long id) {
		return update("delete", id);
	}

	@Override
	public void insert(DuibaQuestionAnswerEntity duibaQuestionAnswerDto) {
		insert("insert", duibaQuestionAnswerDto);
	}

	@Override
	public int update(DuibaQuestionAnswerEntity duibaQuestionAnswerDto) {
		return update("update", duibaQuestionAnswerDto);
	}

	@Override
	public void updateSwitches(Long id, Long switches) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("switches", switches);
		update("updateSwitches", paramMap);
	}

	public int updateAutoOffDateNull(Long id){
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("updateAutoOffDateNull", paramMap);
	}
	
	@Override
	public int updateForEditActivityCategoryId(long id, Long activityCategoryId) {
	    Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("activityCategoryId", activityCategoryId);
        return update("updateForEditActivityCategoryId", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}
}
