package cn.com.duiba.activity.center.biz.dao.game.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.game.DuibaQuestionBankDao;
import cn.com.duiba.activity.center.biz.entity.game.DuibaQuestionBankEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaQuestionBankDaoImpl extends ActivityBaseDao implements DuibaQuestionBankDao {

	@Override
	public void insert(DuibaQuestionBankEntity questionBankDO) {
		insert("insert", questionBankDO);
	}

	@Override
	public List<DuibaQuestionBankEntity> findByPage(Integer offset, Integer max) {
		Map<String, Object> params=new HashMap<String, Object>();
		params.put("offset", offset);
		params.put("max", max);
		return selectList("findByPage", params);
	}

	@Override
	public Long findTotalCount() {
		return selectOne("findTotalCount");
	}

	@Override
	public int updateName(Long id, String name) {
		Map<String, Object> params=new HashMap<String, Object>();
		params.put("id", id);
		params.put("name", name);
		return update("updateName", params);
	}

	@Override
	public int delete(Long id) {
		return update("delete", id);
	}

	@Override
	public List<DuibaQuestionBankEntity> findAll() {
		return selectList("findAll");
	}

	@Override
	public int updateNumberAdd(Long id) {
		return update("updateNumberAdd", id);
	}
	
	@Override
	public int updateNumberSub(Long id) {
		return update("updateNumberSub", id);
	}

	@Override
	public DuibaQuestionBankEntity find(Long id) {
		Map<String, Object> params=new HashMap<String, Object>();
		params.put("id", id);
		return selectOne("find", params);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_GAME;
	}
}
