package cn.com.duiba.activity.center.biz.dao.hdtool.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.hdtool.AppHdtoolOrdersDao;
import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolOrdersEntity;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

import static cn.com.duiba.activity.center.biz.support.TableHelper.getTbSuffixParamsMap;

/**
 * 活动工具订单业务DAO
 */
@Repository
public class AppHdtoolOrdersDaoImpl extends ActivityBaseDao implements AppHdtoolOrdersDao {

	/**
	 * 统计活动失败条数
	 */
	public List<DeveloperActivityStatisticsEntity> countFailByOperatingActivityIds(Long appId, List<Long> ids) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.put("operatingActivityIds", ids);
		return selectList("countFailByOperatingActivityIds", paramMap);
	}
	
	/**
	 * 分页查询
	 */
	public List<HdtoolOrdersEntity> findByLimit(Map<String, Object> queryParam) {
		Long appId=(Long) queryParam.get("appId");
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		queryParam.put("tb_suffix", paramMap.get("tb_suffix"));
		return selectList("findByLimit", queryParam);
	}
	
	/**
	 * 统计条数
	 */
	public Long totalCount(Map<String, Object> queryParam) {
		Long appId=(Long) queryParam.get("appId");
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		queryParam.put("tb_suffix", paramMap.get("tb_suffix"));
		return selectOne("totalCount", queryParam);
	}
	/**
	 * 根据活动订单ID集合查询订单信息
	 */
	public List<HdtoolOrdersEntity> findByIds(Long appId, List<Long> ids) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.put("ids", ids);
		return selectList("findByIds", paramMap);
	}

	/**
	 * 根据ID查询订单
	 */
	public HdtoolOrdersEntity find(Long appId, Long id) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}
	/**
	 * 根据开发者订单号查询订单
	 */
	public HdtoolOrdersEntity findByAppAndDeveloperBizId(Long appId, String bizId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.put("appId", appId);
		paramMap.put("bizId", bizId);
		return selectOne("findByAppAndDeveloperBizId", paramMap);
	}

	public List<HdtoolOrdersEntity> findHdtoolOrderLimit50(Long appId, Long activityId){
		Map<String, Object> paramMap = getTbSuffixParamsMap(appId);
		paramMap.put("activityId", activityId);
		return selectList("findHdtoolOrderLimit50",paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.APP_HDTOOL;
	}
}
