package cn.com.duiba.activity.center.biz.dao.hdtool.impl;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolOrdersDto;
import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.hdtool.CreditsHdtoolOrdersDao;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolOrdersEntity;
import org.springframework.stereotype.Repository;

import java.util.*;

import static cn.com.duiba.activity.center.biz.support.TableHelper.getTbSuffixParamsMap;
import static cn.com.duiba.activity.center.biz.support.TableHelper.subString;

/**
 * hdtool_orders表的consumer维度分表,活动工具订单业务DAO
 */
@Repository
public class CreditsHdtoolOrdersDaoImpl extends ActivityBaseDao implements CreditsHdtoolOrdersDao {

	//from NewHdtoolOrderSimpleDAO in credits

	/**
	 * 根据ID查询订单
	 */
	public HdtoolOrdersEntity find(Long consumerId, Long id) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	/**
	 * 查询用户参与活动次数
	 */
	public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		return selectOne("countByConsumerIdAndOperatingActivityId", paramMap);
	}

	/**
	 * 查询用户在时间段内参与活动次数
	 */
	public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		paramMap.put("start", start);
		paramMap.put("end", end);
		return selectOne("countByConsumerIdAndOperatingActivityIdAndDate", paramMap);
	}

	/**
	 * 查询用户免费参与活动次数
	 */
	public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		return selectOne("countFreeByConsumerIdAndOperatingActivityId", paramMap);
	}

	/**
	 * 查询用户在时间段内免费参与活动次数
	 */
	public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		paramMap.put("start", start);
		paramMap.put("end", end);
		return selectOne("countFreeByConsumerIdAndOperatingActivityIdAndDate", paramMap);
	}

	/**
	 * 查询用户中奖某奖项次数
	 */
	public Integer countByConsumerIdAndPrizeId(Long consumerId, Long operatingActivityId, Long prizeId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("consumerId", consumerId);
		paramMap.put("operatingActivityId", operatingActivityId);
		paramMap.put("prizeId", prizeId);
		return selectOne("countByConsumerIdAndPrizeId", paramMap);
	}

	/**
	 * 根据活动订单ID集合查询订单信息
	 */
	public List<HdtoolOrdersEntity> findByIds(Long consumerId, List<Long> ids) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("ids", ids);
		return selectList("findByIds", paramMap);
	}

	/**
	 * 根据开发者订单号查询订单
	 */
	public HdtoolOrdersEntity findByAppAndDeveloperBizId(Long consumerId, Long appId, String bizId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("appId", appId);
		paramMap.put("bizId", bizId);
		return selectOne("findByAppAndDeveloperBizId", paramMap);
	}

	/**
	 * 根据领取状态exchangeStatus查询小于endTime时间的订单
	 */
	public List<Long> findExpireOrder() {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		Calendar cal = Calendar.getInstance();
		cal.setTime(new Date());
		cal.add(Calendar.DATE, -1);
		Date endTime = cal.getTime();
		Calendar cal1 = Calendar.getInstance();
		cal1.setTime(endTime);
		cal1.add(Calendar.DATE, -1);
		Date startTime = cal1.getTime();
		paramMap.put("startTime", startTime);
		paramMap.put("endTime", endTime);
		paramMap.put("exchangeStatus", HdtoolOrdersEntity.ExchangeStatusWait);
		return selectList("findExpireOrder", paramMap);
	}

	//from NewHdtoolOrderStatusChangeDAO in credits

	/**
	 * 修改订单领奖状态为失败
	 */
	public int updateExchangeStatusToFail(Long consumerId,long id, String error4admin, String error4developer, String error4consumer) {
		//加入异常捕获，防止在过度其间抛出异常，流程中断。
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		paramMap.put("exchangeStatus", HdtoolOrdersEntity.ExchangeStatusFail);
		paramMap.put("error4admin",subString(error4admin,200));
		paramMap.put("error4developer", subString(error4developer,200));
		paramMap.put("error4consumer", subString(error4consumer,200));
		int ret= update("updateExchangeStatusToFail", paramMap);
		return ret;
	}

	/**
	 * 修改订单领奖状态为过期失效
	 */
	public int updateExchangeStatusToOverdue(Long consumerId,long id, String error4admin, String error4developer, String error4consumer) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		paramMap.put("exchangeStatus", HdtoolOrdersEntity.ExchangeStatusOverdue);
		paramMap.put("error4admin", subString(error4admin,200));
		paramMap.put("error4developer", subString(error4developer,200));
		paramMap.put("error4consumer", subString(error4consumer,200));
		int ret= update("updateExchangeStatusToOverdue", paramMap);
		return ret;
	}
	/**
	 * 修改订单状态失败
	 */
	public int updateStatusToFail(Long consumerId,long id, String error4admin, String error4developer, String error4consumer) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		paramMap.put("status", HdtoolOrdersEntity.StatusFail);
		paramMap.put("error4admin", subString(error4admin,200));
		paramMap.put("error4developer", subString(error4developer,200));
		paramMap.put("error4consumer",subString( error4consumer,200));
		int ret= update("updateStatusToFail", paramMap);
		return ret;
	}


	/**
	 * 处理领奖
	 */
	public Integer doTakePrize(Long consumerId,Long id) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		int ret= update("doTakePrize", paramMap);
		return ret;
	}

	/**
	 * 领奖创建订单失败，回滚领奖
	 */
	public Integer rollbackTakePrize(Long consumerId,Long id) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		int ret= update("rollbackTakePrize", paramMap);
		return ret;
	}

	/**
	 * 处理抽奖结果
	 */
	public Integer updateLotteryResult(Long consumerId,Long id ,Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId){
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		paramMap.put("appItemId", appItemId);
		paramMap.put("itemId", itemId);
		paramMap.put("prizeId", prizeId);
		paramMap.put("prizeName", prizeName);
		paramMap.put("prizeType", prizeType);
		paramMap.put("prizeFacePrice", prizeFacePrice);
		paramMap.put("couponId", couponId);
		paramMap.put("status", HdtoolOrdersDto.StatusSuccess);
		paramMap.put("exchangeStatus", HdtoolOrdersDto.ExchangeStatusWait);
		int ret= update("updateLotteryResult", paramMap);
		return ret;
	}

	/**
	 * 福袋中奖降级处理为谢谢参与
	 * @param consumerId
	 * @param id
	 * @param appItemId
	 * @param itemId
	 * @param prizeId
	 * @param prizeName
	 * @param prizeType
	 * @param prizeFacePrice
	 * @param couponId
	 * @return
	 */
	public Integer updateLotteryLuckyResult(Long consumerId,Long id ,Long appItemId, Long itemId, Long prizeId, String prizeName, String prizeType, String prizeFacePrice, Long couponId){
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		paramMap.put("appItemId", appItemId);
		paramMap.put("itemId", itemId);
		paramMap.put("prizeId", prizeId);
		paramMap.put("prizeName", prizeName);
		paramMap.put("prizeType", prizeType);
		paramMap.put("prizeFacePrice", prizeFacePrice);
		paramMap.put("couponId", couponId);
		paramMap.put("status", HdtoolOrdersDto.StatusSuccess);
		paramMap.put("exchangeStatus", HdtoolOrdersDto.ExchangeStatusWait);
		int ret= update("updateLotteryLuckyResult", paramMap);
		return ret;
	}

	//from NewHdtoolOrderTextChangeDAO in credits

	/**
	 * 修改开发者订单号
	 */
	public int updateDeveloperBizId(Long consumerId,long id, String bizId) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		paramMap.put("bizId", bizId);
		int ret= update("updateDeveloperBizId", paramMap);
		return ret;
	}

	/**
	 * 修改抽奖订单主订单号
	 */
	public int updateMainOrderId(Long consumerId,long id, Long mainOrderId, String mainOrderNum) {
		Map<String, Object> paramMap = getTbSuffixParamsMap(consumerId);
		paramMap.put("id", id);
		paramMap.put("mainOrderId", mainOrderId);
		paramMap.put("mainOrderNum", mainOrderNum);
		int ret= update("updateMainOrderId", paramMap);
		return ret;
	}

	/**
	 * 添加活动工具订单
	 */
	public void insert(HdtoolOrdersEntity hdtoolOrdersDto) {
		generateHdtoolOrderSequence(hdtoolOrdersDto);
		Map<String, Object> paramMap = getTbSuffixParamsMap(hdtoolOrdersDto.getConsumerId());
		paramMap.put("mirror", hdtoolOrdersDto);
		insert("insert", paramMap);
	}

	private void generateHdtoolOrderSequence(HdtoolOrdersEntity hdtoolOrdersDto){
		insert("generateHdtoolOrderSequence", hdtoolOrdersDto);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS_HDTOOL;
	}
}
