package cn.com.duiba.activity.center.biz.dao.hdtool.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.hdtool.DuibaHdtoolDao;
import cn.com.duiba.activity.center.biz.entity.ActivityExtraInfoEntity;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.DuibaHdtoolOptionsEntity;
import cn.com.duiba.activity.center.biz.entity.hdtool.HdtoolAppSpecifyEntity;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.*;

/**
 * 兑吧活动工具业务DAO
 */
@Repository
public class DuibaHdtoolDaoImpl extends ActivityBaseDao implements DuibaHdtoolDao {
	
	/**
	 * 查询一天内，需要定时下架的转盘抽奖
	 * @return
	 */
	public List<DuibaHdtoolEntity> findAutoOff(){
		Calendar cal1 = Calendar.getInstance();
		cal1.setTime(new Date());
		cal1.add(Calendar.DATE, -1);
		Date startTime = cal1.getTime();
		
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("startTime", startTime);
		paramMap.put("endTime", new Date());
		return selectList("findAutoOff", paramMap);	
	}

	/**
	 * 根据ID查询
	 */
	public DuibaHdtoolEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	/**
	 * 活动工具分页列表
	 */
	//Start chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30
	//public List<DuibaHdtoolEntity> findDuibaHdToolsList(int offset, int max) {
	public List<DuibaHdtoolEntity> findDuibaHdToolsList(Map<String, Object> paramMap) {
        /*Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("offset", offset);
        paramMap.put("max", max);*/
		//End chaijiangang,管理员后台活动管理页面增加筛选条件,2016/03/30
		return selectList("findDuibaHdToolsList",paramMap);
	}

	/**
	 * 统计活动工具条数
	 */
	public Integer countDuibaHdToolsList(Map<String, Object> queryMap) {
		return selectOne("countDuibaHdToolsList",queryMap);
	}

	/**
	 * 根据APP查询活动工具
	 */
	public List<AddActivityEntity> findAllDuibaHdTools(Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("appId", appId);
		return selectList("findAllDuibaHdTools", paramMap);
	}

	/**
	 * 根据ID集合查询活动工具
	 */
	public List<DuibaHdtoolEntity> findAllByIds(List<Long> ids) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ids", ids);
		return selectList("findAllByIds", paramMap);
	}

	/**
	 * 根据活动ID查询奖项
	 */
	public List<DuibaHdtoolOptionsEntity> findOptionsByDuibaHdtoolId(Long hdtoolId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("hdtoolId", hdtoolId);
		return selectList("findOptionsByDuibaHdtoolId", paramMap);
	}

	/**
	 * 查询活动奖项个数
	 */
	public Integer countOptionsByHdtoolId(Long hdtoolId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("hdtoolId", hdtoolId);
		return selectOne("countOptionsByHdtoolId", paramMap);
	}

	/**
	 * 根据ID查询
	 */
	public DuibaHdtoolOptionsEntity findOptionById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findOptionById", paramMap);
	}
	
	public DuibaHdtoolOptionsEntity findOptionByIdForupdate(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findOptionByIdForupdate", paramMap);
	}
	
	/**
	 * 根据活动ID查询定向
	 */
	public List<HdtoolAppSpecifyEntity> findAllSpecifyByHdToolId(Long hdToolId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("hdToolId", hdToolId);
		return selectList("findAllSpecifyByHdToolId", paramMap);
	}

	/**
	 * 根据活动ID或APP查询定向关系
	 */
	public HdtoolAppSpecifyEntity findSpecifyByHdToolIdAndApp(Long duibaHdToolId, Long appId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("duibaHdToolId", duibaHdToolId);
		paramMap.put("appId", appId);
		return selectOne("findSpecifyByHdToolIdAndApp", paramMap);
	}

	/**
	 * 根据ID查询定向关系
	 */
	public HdtoolAppSpecifyEntity findSpecifyById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findSpecifyById", paramMap);
	}
	
	/**
	 * 根据ID查询额外信息
	 */
	public ActivityExtraInfoEntity findExtraInfoById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("findExtraInfoById", paramMap);
	}


	/**
	 * 查询item是否被活动工具使用
	 *
	 * @param itemId
	 * @return
	 */
	public List<Long> findHasUserdHdIds(Long itemId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("itemId", itemId);
		return selectList("findHasUserdHdIds", paramMap);
	}

	/**
	 * @param queryMap
	 * @return
	 */
	public Long getCountDuibaHdTool(Map<String, Object> queryMap) {
		return selectOne("getCountDuibaHdTool", queryMap);
	}

	/**
	 * @param queryMap
	 * @return
	 */
	public List<DuibaHdtoolEntity> findDuibaToolList(Map<String, Object> queryMap) {
		return selectList("findDuibaToolList", queryMap);
	}

	//from DuibaHdtoolTextChangeDao


	public int updateAutoOffDateNull(Long id){
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("updateAutoOffDateNull", paramMap);
	}

	/**
	 * 新增兑吧活动工具
	 */
	public void insert(DuibaHdtoolEntity duibaHdtoolDto) {
		insert("insert", duibaHdtoolDto);
	}

	/**
	 * 删除兑吧活动
	 */
	public int deleteById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("deleteById", paramMap);
	}

	/**
	 * 修改兑吧活动工具
	 */
	public int update(DuibaHdtoolEntity duibaHdtoolDto) {
		return update("update", duibaHdtoolDto);
	}

	/**
	 * 修改活动工具状态
	 */
	public int updateStatus(Long id, Integer status) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		paramMap.put("status", status);
		return update("updateStatus", paramMap);
	}

	/**
	 * 减奖品数量
	 */
	public int decrementOptionRemaining(@Param("id") Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("decrementOptionRemaining", paramMap);
	}

	/**
	 * 加奖品数量
	 */
	public int incrementOptionRemaining(@Param("id") Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return update("incrementOptionRemaining", paramMap);
	}

	/**
	 * 删除奖项
	 */
	public int deleteOptions(List<Long> ids) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("oaoList", ids);
		return update("deleteOptions", paramMap);
	}

	/**
	 * 修改奖项
	 */
	public int updateHdtoolPrize(DuibaHdtoolOptionsEntity duibaHdToolOptionDO) {
		return update("updateHdtoolPrize", duibaHdToolOptionDO);
	}

	/**
	 * 新增兑换活动工具奖项
	 */
	public void insertHdtoolOption(DuibaHdtoolOptionsEntity duibaHdToolOptionDO) {
		insert("insertHdtoolOption", duibaHdToolOptionDO);
	}

	/**
	 * 修改兑吧活动工具
	 */
	public int updateHdtoolOption(DuibaHdtoolOptionsEntity duibaHdToolOptionDO) {
		return update("updateHdtoolOption", duibaHdToolOptionDO);
	}

	/**
	 * 删除定向关系
	 */
	public int deleteSpecifyById(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return delete("deleteSpecifyById", paramMap);
	}

	/**
	 * 添加定向关系
	 */
	public void insertSpecify(HdtoolAppSpecifyEntity hdtoolAppSpecifyDO) {
		insert("insertSpecify", hdtoolAppSpecifyDO);
	}
	
	public int updateActivityCategory(long  duibaHdtoolId,long activityCategoryId){
	    Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", duibaHdtoolId);
        paramMap.put("activityCategoryId", activityCategoryId);
	    return update("updateActivityCategory", paramMap);
	}

	/**
     * 根据ID查询标签
     */
    public String findTag(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("findTag", paramMap);
    }

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.CREDITS;
	}
}
