package cn.com.duiba.activity.center.biz.dao.ngame.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.ngame.DuibaNgameOptionsDao;
import cn.com.duiba.activity.center.biz.entity.ngame.DuibaNgameOptionsEntity;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public class DuibaNgameOptionsDaoImpl extends ActivityBaseDao implements DuibaNgameOptionsDao {

	@Override
	public List<DuibaNgameOptionsEntity> findByGameId(Long duibaNgameId) {
		return selectList("findByGameId", duibaNgameId);
	}

	@Override
	public void addBatch(List<DuibaNgameOptionsEntity> list) {
		Map<String, Object> params = Maps.newHashMap();
		params.put("list", list);
		insert("addBatch", params);
	}

	@Override
	public void add(DuibaNgameOptionsEntity duibaNgameOptionsDto) {
		insert("add", duibaNgameOptionsDto);
	}

	@Override
	public void delete(Long id) {
		update("delete", id);
	}

	@Override
	public void update(DuibaNgameOptionsEntity duibaNgameOptionsDto) {
		update("update", duibaNgameOptionsDto);
	}

	@Override
	public Integer countBigPrizeByGameId(Long duibaNgameId) {
		return selectOne("countBigPrizeByGameId", duibaNgameId);
	}

	@Override
	public DuibaNgameOptionsEntity find(Long id) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("id", id);
		return selectOne("find", paramMap);
	}

	@Override
	public List<DuibaNgameOptionsEntity> findByAutoOpen(Long ngameId, boolean autoOpen) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ngameId", ngameId);
		paramMap.put("autoOpen", autoOpen);
		return selectList("findByAutoOpen", paramMap);
	}
	
	@Override
	public List<DuibaNgameOptionsEntity> findByAutoOpenDesc(Long ngameId, boolean autoOpen) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ngameId", ngameId);
		paramMap.put("autoOpen", autoOpen);
		return selectList("findByAutoOpenDesc", paramMap);
	}

	@Override
	public List<DuibaNgameOptionsEntity> findDisplayOption(Long ngameId) {
		Map<String, Object> paramMap = new HashMap<String, Object>();
		paramMap.put("ngameId", ngameId);
		return selectList("findDisplayOption", paramMap);
	}

	@Override
	protected DatabaseSchema chooseSchema() {
		return DatabaseSchema.NGAME;
	}
}
