package cn.com.duiba.activity.center.biz.remoteservice.impl.game;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.activity.center.api.remoteservice.game.RemoteDuibaQuestionAnswerOptionsService;
import cn.com.duiba.activity.center.biz.bo.game.DuibaQuestionAnswerOptionsBo;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionAnswerOptionsService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/5/31.
 */
@Service
public class RemoteDuibaQuestionAnswerOptionsServiceImpl implements RemoteDuibaQuestionAnswerOptionsService {
    @Resource
    private DuibaQuestionAnswerOptionsService duibaQuestionAnswerOptionsService;
    @Resource
    private DuibaQuestionAnswerOptionsBo duibaQuestionAnswerOptionsBo;

    @Override
    public List<DuibaQuestionAnswerOptionsDto> findOptionsByQuestionId(Long duibaQuestionId) {
        return duibaQuestionAnswerOptionsService.findOptionsByQuestionId(duibaQuestionId);
    }

    @Override
    public DuibaQuestionAnswerOptionsDto find(Long id) {
        return duibaQuestionAnswerOptionsService.find(id);
    }

    @Override
    public DuibaQuestionAnswerOptionsDto findById(Long id) {
        return duibaQuestionAnswerOptionsService.findById(id);
    }

    @Override
    public int delete(List<Long> ids) {
        return duibaQuestionAnswerOptionsService.delete(ids);
    }

    @Override
    public DuibaQuestionAnswerOptionsDto insert(DuibaQuestionAnswerOptionsDto questionAnswerOptionsDO) {
        duibaQuestionAnswerOptionsService.insert(questionAnswerOptionsDO);
        return questionAnswerOptionsDO;
    }

    @Override
    public int update(DuibaQuestionAnswerOptionsDto questionAnswerOptionsDO) {
        return duibaQuestionAnswerOptionsService.update(questionAnswerOptionsDO);
    }

    @Override
    public List<DuibaQuestionAnswerOptionsDto> findByQuestionAnswerId(Long questionAnswerId) {
        return duibaQuestionAnswerOptionsBo.findByQuestionAnswerId(questionAnswerId);
    }
}
