package cn.com.duiba.activity.center.biz.remoteservice.impl.game;

import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionAnswerOptionsDto;
import cn.com.duiba.activity.center.api.dto.game.DuibaQuestionStockDto;
import cn.com.duiba.activity.center.api.remoteservice.game.RemoteDuibaQuestionStockService;
import cn.com.duiba.activity.center.biz.bo.game.DuibaQuestionStockBo;
import cn.com.duiba.activity.center.biz.service.game.DuibaQuestionStockService;
import cn.com.duiba.service.exception.BusinessException;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by wenqi.huang on 16/6/1.
 */
@Service
public class RemoteDuibaQuestionStockServiceImpl implements RemoteDuibaQuestionStockService {
    @Resource
    private DuibaQuestionStockService duibaQuestionStockService;

    @Resource
    private DuibaQuestionStockBo duibaQuestionStockBo;

    @Override
    public DuibaQuestionStockDto findRemaining(Long questionOptionId, String type) {
        return duibaQuestionStockService.findRemaining(questionOptionId, type);
    }

    @Override
    public List<DuibaQuestionStockDto> findByQuestionOptionIds(List<Long> list) {
        return duibaQuestionStockService.findByQuestionOptionIds(list);
    }

    @Override
    public void consumeStock(Long questionOptionId, String bizId) throws BusinessException {
        duibaQuestionStockBo.consumeStock(questionOptionId, bizId);
    }

    @Override
    public void paybackStock(String questionOrderId) throws BusinessException {
        duibaQuestionStockBo.paybackStock(questionOrderId);
    }

    @Override
    public void updateStockByOptions(DuibaQuestionAnswerOptionsDto option) {
        duibaQuestionStockBo.updateStockByOptions(option);
    }

    @Override
    public void updateStockByOptions(DuibaQuestionAnswerOptionsDto option, DuibaQuestionAnswerOptionsDto old) throws BusinessException {
        duibaQuestionStockBo.updateStockByOptions(option, old);
    }

}
