package cn.com.duiba.activity.center.biz.remoteservice.impl.hdtool;

import cn.com.duiba.activity.center.api.dto.ActivityExtraInfoDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolAppSpecifyDto;
import cn.com.duiba.activity.center.api.dto.quizz.AddActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.hdtool.RemoteDuibaHdtoolServiceNew;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/5/19.
 */
@Service
public class RemoteDuibaHdtoolServiceNewImpl implements RemoteDuibaHdtoolServiceNew {
    @Resource
    private DuibaHdtoolService duibaHdtoolService;

    @Override
    public List<DuibaHdtoolDto> findAutoOff() {
        return duibaHdtoolService.findAutoOff();
    }

    @Override
    public DuibaHdtoolDto find(Long id) {
        return duibaHdtoolService.find(id);
    }

    @Override
    public List<DuibaHdtoolDto> findDuibaHdToolsList(Map<String, Object> paramMap) {
        return duibaHdtoolService.findDuibaHdToolsList(paramMap);
    }

    @Override
    public Integer countDuibaHdToolsList(Map<String, Object> queryMap) {
        return duibaHdtoolService.countDuibaHdToolsList(queryMap);
    }

    @Override
    public List<AddActivityDto> findAllDuibaHdTools(Long appId) {
        return duibaHdtoolService.findAllDuibaHdTools(appId);
    }

    @Override
    public List<DuibaHdtoolDto> findAllByIds(List<Long> ids) {
        return duibaHdtoolService.findAllByIds(ids);
    }

    @Override
    public List<DuibaHdtoolOptionsDto> findOptionsByDuibaHdtoolId(Long hdtoolId) {
        return duibaHdtoolService.findOptionsByDuibaHdtoolId(hdtoolId);
    }

    @Override
    public Integer countOptionsByHdtoolId(Long hdtoolId) {
        return duibaHdtoolService.countOptionsByHdtoolId(hdtoolId);
    }

    @Override
    public DuibaHdtoolOptionsDto findOptionById(Long id) {
        return duibaHdtoolService.findOptionById(id);
    }

    @Override
    public List<HdtoolAppSpecifyDto> findAllSpecifyByHdToolId(Long hdToolId) {
        return duibaHdtoolService.findAllSpecifyByHdToolId(hdToolId);
    }

    @Override
    public HdtoolAppSpecifyDto findSpecifyByHdToolIdAndApp(Long duibaHdToolId, Long appId) {
        return duibaHdtoolService.findSpecifyByHdToolIdAndApp(duibaHdToolId, appId);
    }

    @Override
    public HdtoolAppSpecifyDto findSpecifyById(Long id) {
        return duibaHdtoolService.findSpecifyById(id);
    }

    @Override
    public ActivityExtraInfoDto findExtraInfoById(Long id) {
        return duibaHdtoolService.findExtraInfoById(id);
    }

    @Override
    public List<Long> findHasUserdHdIds(Long itemId) {
        return duibaHdtoolService.findHasUserdHdIds(itemId);
    }

    @Override
    public Long getCountDuibaHdTool(Map<String, Object> queryMap) {
        return duibaHdtoolService.getCountDuibaHdTool(queryMap);
    }

    @Override
    public List<DuibaHdtoolDto> findDuibaToolList(Map<String, Object> queryMap) {
        return duibaHdtoolService.findDuibaToolList(queryMap);
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        return duibaHdtoolService.updateAutoOffDateNull(id);
    }

    @Override
    public DuibaHdtoolDto insert(DuibaHdtoolDto duibaHdtoolDto) {
        duibaHdtoolService.insert(duibaHdtoolDto);
        return duibaHdtoolDto;
    }

    @Override
    public int deleteById(Long id) {
        return duibaHdtoolService.deleteById(id);
    }

    @Override
    public int update(DuibaHdtoolDto duibaHdtoolDto) {
        return duibaHdtoolService.update(duibaHdtoolDto);
    }

    @Override
    public int updateStatus(Long id, Integer status) {
        return duibaHdtoolService.updateStatus(id, status);
    }

    @Override
    public int decrementOptionRemaining(Long id) {
        return duibaHdtoolService.decrementOptionRemaining(id);
    }

    @Override
    public int incrementOptionRemaining(Long id) {
        return duibaHdtoolService.incrementOptionRemaining(id);
    }

    @Override
    public int deleteOptions(List<Long> ids) {
        return duibaHdtoolService.deleteOptions(ids);
    }

    @Override
    public int updateHdtoolPrize(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        return duibaHdtoolService.updateHdtoolPrize(duibaHdToolOptionDO);
    }

    @Override
    public DuibaHdtoolOptionsDto insertHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        duibaHdtoolService.insertHdtoolOption(duibaHdToolOptionDO);
        return duibaHdToolOptionDO;
    }

    @Override
    public int updateHdtoolOption(DuibaHdtoolOptionsDto duibaHdToolOptionDO) {
        return duibaHdtoolService.updateHdtoolOption(duibaHdToolOptionDO);
    }

    @Override
    public int deleteSpecifyById(Long id) {
        return duibaHdtoolService.deleteSpecifyById(id);
    }

    @Override
    public HdtoolAppSpecifyDto insertSpecify(HdtoolAppSpecifyDto hdtoolAppSpecifyDO) {
        duibaHdtoolService.insertSpecify(hdtoolAppSpecifyDO);
        return hdtoolAppSpecifyDO;
    }
//
//    @Override
//    public DuibaHdtoolOptionsDto findOptionByIdForupdate(Long id) {
//        return duibaHdtoolService.findOptionByIdForupdate(id);
//    }

    @Override
    public String findTag(Long id) {
        return duibaHdtoolService.findTag(id);
    }

    @Override
    public int updateActivityCategory(long duibaHdtoolId, long activityCategoryId) {
        return duibaHdtoolService.updateActivityCategory(duibaHdtoolId, activityCategoryId);
    }
}
