package cn.com.duiba.activity.center.biz.remoteservice.impl.hdtool;

import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolSkinDefaultDto;
import cn.com.duiba.activity.center.api.remoteservice.hdtool.RemoteHdtoolSkinDefaultDataSerivce;
import cn.com.duiba.activity.center.biz.service.hdtool.HdtoolSkinDefaultDataSerivce;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yansen on 16/7/5.
 */
@Service
public class RemoteHdtoolSkinDefaultDataSerivceImpl implements RemoteHdtoolSkinDefaultDataSerivce {

    private static Logger log = LoggerFactory.getLogger(RemoteHdtoolSkinDefaultDataSerivceImpl.class);

    @Autowired
    private HdtoolSkinDefaultDataSerivce hdtoolSkinDefaultDataSerivce;

    @Override
    public void createHdtoolDefaultSkin(HdtoolSkinDefaultDto hdtoolSkinDefaultDto) {
        try{
            hdtoolSkinDefaultDataSerivce.createHdtoolDefaultSkin(hdtoolSkinDefaultDto);
        }catch(Exception e){
            log.error("创建默认模版配置失败,class:" + this.getClass().getName() + ",method=createHdtoolDefaultSkin");
        }
    }

    @Override
    public DubboResult<Integer> updateHdtoolDefaultSkin(HdtoolSkinDefaultDto hdtoolSkinDefaultDto) {
        try{
            return DubboResult.successResult(hdtoolSkinDefaultDataSerivce.updateHdtoolDefaultSkin(hdtoolSkinDefaultDto));
        }catch(Exception e){
            log.error("更新默认模版配置失败，class:" + this.getClass().getName() + ",method=updateHdtoolDefaultSkin");
            return DubboResult.failResult("更新默认模版失败");
        }
    }

    @Override
    public DubboResult<HdtoolSkinDefaultDto> queryHdtoolBaseSkin(String templateType, String type) {
        try{
            return DubboResult.successResult(hdtoolSkinDefaultDataSerivce.queryHdtoolBaseSkin(templateType, type));
        }catch(Exception e){
            log.error("查询默认模版配置失败，class:" + this.getClass().getName() + ",method=queryHdtoolBaseSkin");
            return DubboResult.failResult("查询默认模版配置失败");
        }
    }

    @Override
    public DubboResult<HdtoolSkinDefaultDto> queryHdtoolDefaultConfig(String templateType, String type) {
        try{
            return DubboResult.successResult(hdtoolSkinDefaultDataSerivce.queryHdtoolDefaultConfig(templateType, type));
        }catch(Exception e){
            log.error("查询默认模版配置数据失败，class:" + this.getClass().getName() + ",method=queryHdtoolDefaultConfig");
            return DubboResult.failResult("查询默认模版配置数据失败");
        }
    }

    @Override
    public DubboResult<List<HdtoolSkinDefaultDto>> queryListPagnation(Integer offset, Integer max) {
        try{
            return DubboResult.successResult(hdtoolSkinDefaultDataSerivce.queryListPagnation(offset, max));
        }catch(Exception e){
            log.error("查询默认模版配置列表失败，class:" + this.getClass().getName() + ",method=queryListPagnation");
            return DubboResult.failResult("查询默认模版配置列表失败");
        }
    }

    @Override
    public DubboResult<Integer> queryListCount() {
        try{
            return DubboResult.successResult(hdtoolSkinDefaultDataSerivce.queryListCount());
        }catch(Exception e){
            log.error("查询默认模版配置列表条数，class:" + this.getClass().getName() + ",method=queryListCount");
            return DubboResult.failResult("查询默认模版配置列表条数失败");
        }
    }
}
