package cn.com.duiba.activity.center.biz.remoteservice.impl.ngame;

import cn.com.duiba.activity.center.api.dto.ngame.NgameConsumerRecordDto;
import cn.com.duiba.activity.center.api.remoteservice.ngame.RemoteNgameConsumerRecordService;
import cn.com.duiba.activity.center.biz.service.ngame.NgameConsumerRecordService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/6/16.
 */
@Service
public class RemoteNgameConsumerRecordServiceImpl implements RemoteNgameConsumerRecordService {
    @Resource
    private NgameConsumerRecordService ngameConsumerRecordService;

    @Override
    public NgameConsumerRecordDto findRecordByConIdAndNgameId(Long consumerId, Long duibaNgameId) {
        return ngameConsumerRecordService.findRecordByConIdAndNgameId(consumerId, duibaNgameId);
    }

    @Override
    public List<NgameConsumerRecordDto> findGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number) {
        return ngameConsumerRecordService.findGameConfigDuibaScoreByDesc(duibaNgameId, number);
    }

    @Override
    public List<NgameConsumerRecordDto> findGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number) {
        return ngameConsumerRecordService.findGameConfigDuibaScoreByAsc(duibaNgameId, number);
    }

    @Override
    public List<NgameConsumerRecordDto> findConsumerGameConfigDuibaScoreByDesc(Long duibaNgameId, Integer number) {
        return ngameConsumerRecordService.findConsumerGameConfigDuibaScoreByDesc(duibaNgameId, number);
    }

    @Override
    public List<NgameConsumerRecordDto> findConsumerGameConfigDuibaScoreByAsc(Long duibaNgameId, Integer number) {
        return ngameConsumerRecordService.findConsumerGameConfigDuibaScoreByAsc(duibaNgameId, number);
    }

    @Override
    public NgameConsumerRecordDto insert(NgameConsumerRecordDto gameConsumerRecordDO) {
        ngameConsumerRecordService.insert(gameConsumerRecordDO);
        return gameConsumerRecordDO;
    }

    @Override
    public Integer updateScore(Long id, Long score, String autoOpenPrizeId, Long gameOrderId) {
        return ngameConsumerRecordService.updateScore(id, score, autoOpenPrizeId, gameOrderId);
    }

    @Override
    public Integer updateScoreAndTotalScore(Long id, Long score, Integer shareScore, String autoOpenPrizeId, Long gameOrderId) {
        return ngameConsumerRecordService.updateScoreAndTotalScore(id, score, shareScore, autoOpenPrizeId, gameOrderId);
    }

    @Override
    public Integer updateTotalScore(Long id, Integer shareScore) {
        return ngameConsumerRecordService.updateTotalScore(id, shareScore);
    }

    @Override
    public Integer updateIsGivePrize(Long id, Boolean isGivePrize) {
        return ngameConsumerRecordService.updateIsGivePrize(id, isGivePrize);
    }

    @Override
    public Integer updateAutoOpenPrizeId(Long id, String autoOpenPrizeId) {
        return ngameConsumerRecordService.updateAutoOpenPrizeId(id, autoOpenPrizeId);
    }

    @Override
    public void markCheat(Long id, Boolean cheat) {
        ngameConsumerRecordService.markCheat(id, cheat);
    }

    @Override
    public List<NgameConsumerRecordDto> findByConsumerAndIds(Long consumerId, List<Long> ids) {
        return ngameConsumerRecordService.findByConsumerAndIds(consumerId, ids);
    }

    @Override
    public List<NgameConsumerRecordDto> findTopWinning(Map<String, Object> params) {
        return ngameConsumerRecordService.findTopWinning(params);
    }

    @Override
    public List<NgameConsumerRecordDto> findTopWinningAsc(Map<String, Object> params) {
        return ngameConsumerRecordService.findTopWinningAsc(params);
    }

    @Override
    public Integer countCheatBefore(Integer limit, Long gameConfigDuibaId) {
        return ngameConsumerRecordService.countCheatBefore(limit, gameConfigDuibaId);
    }

    @Override
    public Integer countTopWinning(Map<String, Object> params) {
        return ngameConsumerRecordService.countTopWinning(params);
    }

    @Override
    public NgameConsumerRecordDto find(Long id) {
        return ngameConsumerRecordService.find(id);
    }

    @Override
    public void setCheatReason(Long id, String cheatReason) {
        ngameConsumerRecordService.setCheatReason(id, cheatReason);
    }

    @Override
    public List<NgameConsumerRecordDto> findShareConsumerByGameConfigDuibaId(Long duibaNgameId) {
        return ngameConsumerRecordService.findShareConsumerByGameConfigDuibaId(duibaNgameId);
    }

    @Override
    public int updateByGameConfigShare(Long id, Long duibaNgameId, Long shareScore) {
        return ngameConsumerRecordService.updateByGameConfigShare(id, duibaNgameId, shareScore);
    }

    @Override
    public NgameConsumerRecordDto findByConsumerIdAndGameConfigDuibaId(Long consumerId, Long gameConfigDuibaId) {
        return ngameConsumerRecordService.findByConsumerIdAndGameConfigDuibaId(consumerId, gameConfigDuibaId);
    }

    public void updateScore(Long id, Long score){
        ngameConsumerRecordService.updateScore(id, score);
    }
}
