package cn.com.duiba.activity.center.biz.remoteservice.impl.quizz;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzOptionsDto;
import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockDto;
import cn.com.duiba.activity.center.api.remoteservice.quizz.RemoteQuizzStockService;
import cn.com.duiba.activity.center.biz.service.quizz.QuizzStockService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by xuezhaoming on 16/6/15.
 */
@Service
public class RemoteQuizzStockServiceImpl implements RemoteQuizzStockService {

    @Resource
    private QuizzStockService quizzStockService;

    @Override
    public int subStock(Long id, Integer subNumber) {
        return quizzStockService.subStock(id, subNumber);
    }

    @Override
    public int addStock(Long id, Integer addNumber) {
        return quizzStockService.addStock(id, addNumber);
    }

    @Override
    public DuibaQuizzStockDto findRemaining(Long optionId) {
        return quizzStockService.findRemaining(optionId);
    }

    @Override
    public DuibaQuizzStockDto findByQuizzOptionId(Long questionOptionId) {
        return quizzStockService.findByQuizzOptionId(questionOptionId);
    }

    @Override
    public List<DuibaQuizzStockDto> findByQuizzOptionIds(List<Long> list) {
        return quizzStockService.findByQuizzOptionIds(list);
    }

    @Override
    public int updateStockAdd(Long id, Integer stockAdd) {
        return quizzStockService.updateStockAdd(id, stockAdd);
    }

    @Override
    public int updateStockSub(Long id, Integer stockSub) {
        return quizzStockService.updateStockSub(id, stockSub);
    }

    @Override
    public void add(DuibaQuizzStockDto quizzStockDO) {
        quizzStockService.add(quizzStockDO);
    }

    @Override
    public void addBatch(List<DuibaQuizzStockDto> list) {
        quizzStockService.addBatch(list);
    }

    @Override
    public void updateStockByOptions(DuibaQuizzOptionsDto option) {
        quizzStockService.updateStockByOptions(option);
    }

    @Override
    public void updateStockByOptions(DuibaQuizzOptionsDto option, DuibaQuizzOptionsDto old) throws Exception {
        quizzStockService.updateStockByOptions(option, old);
    }
}
